/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ActivityId;
import com.intellij.history.ByteContent;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.Content;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001WB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0015J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J#\u0010\u001b\u001a\u00020\u00192\r\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$J \u0010%\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u0016\u0010*\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001dJ\u0016\u0010,\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020$J\u0016\u0010.\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001dJ\u0016\u00100\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001d2\u0006\u00101\u001a\u000202J%\u00103\u001a\u0002042\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u000207H\u0007J\u001d\u00108\u001a\u0002042\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u00105\u001a\u00020\u001dH\u0007J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010:\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u0002042\u0006\u0010:\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010:\u001a\u00020?H\u0007J \u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020;H\u0002J\u000e\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020HJ0\u0010I\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u0010J\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020$H\u0007J0\u0010M\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u0010N\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020$H\u0007J\u0018\u0010O\u001a\u00020\u00192\u0006\u0010P\u001a\u00020\u00102\b\u0010Q\u001a\u0004\u0018\u00010RJ\u000e\u0010S\u001a\u00020\u00192\u0006\u0010P\u001a\u00020\u0010J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006X"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade;", "", "<init>", "()V", "storageDir", "Ljava/nio/file/Path;", "getStorageDir$intellij_platform_lvcs_impl", "()Ljava/nio/file/Path;", "changeList", "Lcom/intellij/history/core/ChangeList;", "getChangeList$intellij_platform_lvcs_impl", "()Lcom/intellij/history/core/ChangeList;", "createStorage", "Lcom/intellij/history/core/ChangeListStorage;", "listeners", "", "Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "changeListInTests", "getChangeListInTests", "changes", "", "Lcom/intellij/history/core/changes/ChangeSet;", "getChanges$intellij_platform_lvcs_impl", "()Ljava/lang/Iterable;", "beginChangeSet", "", "forceBeginChangeSet", "endChangeSet", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "created", "path", "isDirectory", "", "contentChanged", "oldContent", "Lcom/intellij/history/core/Content;", "oldTimestamp", "", "renamed", "oldName", "readOnlyStatusChanged", "oldStatus", "moved", "oldParent", "deleted", "deletedEntry", "Lcom/intellij/history/core/tree/Entry;", "putSystemLabel", "Lcom/intellij/history/core/LabelImpl;", "projectId", "color", "", "putUserLabel", "addChange", "c", "Lcom/intellij/history/core/changes/Change;", "addChangeInTests", "Lcom/intellij/history/core/changes/StructuralChange;", "putLabel", "Lcom/intellij/history/core/changes/PutLabelChange;", "putLabelInTests", "getByteContentBefore", "Lcom/intellij/history/ByteContent;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "change", "accept", "v", "Lcom/intellij/history/core/changes/ChangeVisitor;", "revertUpToChangeSet", "changeSetId", "revertTarget", "warnOnFileNotFound", "revertUpToChange", "changeId", "addListener", "l", "parent", "Lcom/intellij/openapi/Disposable;", "removeListener", "fireChangeAdded", "fireChangeSetFinished", "changeSet", "Listener", "intellij.platform.lvcs.impl"})
public class LocalHistoryFacade {
    @NotNull
    private final ChangeList changeList = new ChangeList(this.createStorage());
    @NotNull
    private final List<Listener> listeners;

    public LocalHistoryFacade() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
    }

    @NotNull
    public final Path getStorageDir$intellij_platform_lvcs_impl() {
        String[] stringArray = new String[]{"LocalHistory"};
        Path path = Path.of(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @NotNull
    public final ChangeList getChangeList$intellij_platform_lvcs_impl() {
        return this.changeList;
    }

    @ApiStatus.Internal
    @NotNull
    protected ChangeListStorage createStorage() {
        ChangeListStorage storage = null;
        try {
            storage = new ChangeListStorageImpl(this.getStorageDir$intellij_platform_lvcs_impl());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage = new InMemoryChangeListStorage();
        }
        return storage;
    }

    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public final ChangeList getChangeListInTests() {
        return this.changeList;
    }

    @NotNull
    public final Iterable<ChangeSet> getChanges$intellij_platform_lvcs_impl() {
        return this.changeList.iterChanges();
    }

    public final void beginChangeSet() {
        this.changeList.beginChangeSet();
    }

    public final void forceBeginChangeSet() {
        ChangeSet lastChangeSet = this.changeList.forceBeginChangeSet();
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name, @Nullable ActivityId activityId) {
        ChangeSet lastChangeSet = this.changeList.endChangeSet(name, activityId);
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    public static /* synthetic */ void endChangeSet$default(LocalHistoryFacade localHistoryFacade, String string, ActivityId activityId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endChangeSet");
        }
        if ((n & 2) != 0) {
            activityId = null;
        }
        localHistoryFacade.endChangeSet(string, activityId);
    }

    public final void created(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.addChange(isDirectory ? (CreateEntryChange)new CreateDirectoryChange(this.changeList.nextId(), path) : (CreateEntryChange)new CreateFileChange(this.changeList.nextId(), path));
    }

    @ApiStatus.Internal
    public final void contentChanged(@NotNull String path, @NotNull Content oldContent, long oldTimestamp) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        this.addChange(new ContentChange(this.changeList.nextId(), path, oldContent, oldTimestamp));
    }

    public final void renamed(@NotNull String path, @NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        this.addChange(new RenameChange(this.changeList.nextId(), path, oldName));
    }

    public final void readOnlyStatusChanged(@NotNull String path, boolean oldStatus) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.addChange(new ROStatusChange(this.changeList.nextId(), path, oldStatus));
    }

    public final void moved(@NotNull String path, @NotNull String oldParent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldParent, (String)"oldParent");
        this.addChange(new MoveChange(this.changeList.nextId(), path, oldParent));
    }

    public final void deleted(@NotNull String path, @NotNull Entry deletedEntry) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)deletedEntry, (String)"deletedEntry");
        this.addChange(new DeleteChange(this.changeList.nextId(), path, deletedEntry));
    }

    @ApiStatus.Internal
    @NotNull
    public final LabelImpl putSystemLabel(@NotNull String name, @NotNull String projectId, int color) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutSystemLabelChange(this.changeList.nextId(), name, projectId, color));
    }

    @ApiStatus.Internal
    @NotNull
    public final LabelImpl putUserLabel(@NotNull String name, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutLabelChange(this.changeList.nextId(), name, projectId));
    }

    private final void addChange(Change c) {
        this.beginChangeSet();
        this.changeList.addChange(c);
        this.fireChangeAdded(c);
        LocalHistoryFacade.endChangeSet$default(this, null, null, 2, null);
    }

    @TestOnly
    public final void addChangeInTests(@NotNull StructuralChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.addChange(c);
    }

    private final LabelImpl putLabel(PutLabelChange c) {
        this.addChange(c);
        return new LabelImpl(c, this){
            final /* synthetic */ PutLabelChange $c;
            final /* synthetic */ LocalHistoryFacade this$0;
            {
                this.$c = $c;
                this.this$0 = $receiver;
            }

            public long getLabelChangeId() {
                return this.$c.getId();
            }

            public ByteContent getByteContent(RootEntry root, String path) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return LocalHistoryFacade.access$getByteContentBefore(this.this$0, root, path, this.$c);
            }
        };
    }

    @TestOnly
    public final void putLabelInTests(@NotNull PutLabelChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.putLabel(c);
    }

    private final ByteContent getByteContentBefore(RootEntry root, String path, Change change) {
        RootEntry rootEntry = root.copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry, (String)"copy(...)");
        RootEntry rootCopy = rootEntry;
        String newPath = this.revertUpToChange(rootCopy, change.getId(), path, false, false);
        Entry entry = rootCopy.findEntry(newPath);
        if (entry == null) {
            return new ByteContent(false, null);
        }
        if (entry.isDirectory()) {
            return new ByteContent(true, null);
        }
        return new ByteContent(false, entry.getContent().getBytesIfAvailable());
    }

    public final void accept(@NotNull ChangeVisitor v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.changeList.accept(v);
    }

    @ApiStatus.Internal
    @NotNull
    public final String revertUpToChangeSet(@NotNull RootEntry root, long changeSetId, @NotNull String path, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String entryPath = path;
        for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            if (!revertTarget && changeSet.getId() == changeSetId) break;
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!(change instanceof StructuralChange) || !((StructuralChange)change).affectsPath(entryPath)) continue;
                ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
            }
            if (!revertTarget || changeSet.getId() != changeSetId) continue;
            break;
        }
        return entryPath;
    }

    @ApiStatus.Internal
    @NotNull
    public final String revertUpToChange(@NotNull RootEntry root, long changeId, @NotNull String path, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String entryPath = path;
        block0: for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!revertTarget && change.getId() == changeId) break block0;
                if (change instanceof StructuralChange && ((StructuralChange)change).affectsPath(entryPath)) {
                    ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                    Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
                }
                if (!revertTarget || change.getId() != changeId) continue;
                break block0;
            }
        }
        return entryPath;
    }

    public final void addListener(@NotNull Listener l, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> LocalHistoryFacade.addListener$lambda$0(this, l));
        }
    }

    public final void removeListener(@NotNull Listener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    private final void fireChangeAdded(Change c) {
        for (Listener each : this.listeners) {
            each.changeAdded(c);
        }
    }

    private final void fireChangeSetFinished(ChangeSet changeSet) {
        for (Listener each : this.listeners) {
            each.changeSetFinished(changeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name) {
        LocalHistoryFacade.endChangeSet$default(this, name, null, 2, null);
    }

    private static final void addListener$lambda$0(LocalHistoryFacade this$0, Listener $l) {
        this$0.listeners.remove($l);
    }

    public static final /* synthetic */ ByteContent access$getByteContentBefore(LocalHistoryFacade $this, RootEntry root, String path, Change change) {
        return $this.getByteContentBefore(root, path, change);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "", "<init>", "()V", "changeAdded", "", "c", "Lcom/intellij/history/core/changes/Change;", "changeSetFinished", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "intellij.platform.lvcs.impl"})
    public static abstract class Listener {
        public void changeAdded(@NotNull Change c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        }

        public void changeSetFinished(@NotNull ChangeSet changeSet) {
            Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        }
    }
}

