/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.hierarchy.ExistingHierarchy;
import org.assertj.swing.hierarchy.TransientWindowListener;
import org.assertj.swing.hierarchy.WindowFilter;
import org.assertj.swing.listener.WeakEventListener;
import org.assertj.swing.util.ToolkitProvider;

public class NewHierarchy
extends ExistingHierarchy {
    private final WindowFilter filter;
    private final TransientWindowListener transientWindowListener;

    @Nonnull
    public static NewHierarchy ignoreExistingComponents() {
        return new NewHierarchy(true);
    }

    @Nonnull
    public static NewHierarchy includeExistingComponents() {
        return new NewHierarchy(false);
    }

    private NewHierarchy(boolean ignoreExisting) {
        this(ToolkitProvider.instance().defaultToolkit(), ignoreExisting);
    }

    private NewHierarchy(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        this.filter = new WindowFilter(this.parentFinder(), this.childrenFinder());
        this.transientWindowListener = new TransientWindowListener(this.filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @VisibleForTesting
    NewHierarchy(@Nonnull Toolkit toolkit, @Nonnull WindowFilter filter, boolean ignoreExisting) {
        this.filter = filter;
        this.transientWindowListener = new TransientWindowListener(filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @RunsInCurrentThread
    private void setUp(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        if (ignoreExisting) {
            this.ignoreExisting();
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this.transientWindowListener, 65L);
    }

    @RunsInCurrentThread
    public void ignoreExisting() {
        for (Container c : this.roots()) {
            if (c == null) continue;
            this.filter.ignore(c);
        }
    }

    @RunsInCurrentThread
    public void recognize(@Nonnull Component c) {
        this.filter.recognize(c);
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        if (this.filter.isIgnored(c)) {
            return Lists.emptyList();
        }
        Collection<Component> children = super.childrenOf(c);
        children.removeAll(this.filter.filtered());
        return children;
    }

    @Override
    @RunsInCurrentThread
    public boolean contains(@Nonnull Component c) {
        return super.contains(c) && !this.filter.isIgnored(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (!this.contains(w)) {
            return;
        }
        super.dispose(w);
        this.filter.ignore(w);
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        Collection<Container> roots = super.roots();
        roots.removeAll(this.filter.filtered());
        return roots;
    }
}

