/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.PyVariableLocator;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class RunCustomOperationCommand<T>
extends AbstractCommand<T> {
    private static final Logger LOG = Logger.getInstance(RunCustomOperationCommand.class);
    private final String myEncodedCodeOrFile;
    private final String myOperationFnName;
    private final PyVariableLocator myLocator;
    private final String myStyle;

    private RunCustomOperationCommand(RemoteDebugger target, PyVariableLocator locator, String style, String codeOrFile, String operationFnName) {
        super(target, 135);
        this.myLocator = locator;
        this.myStyle = style;
        this.myEncodedCodeOrFile = RunCustomOperationCommand.encode(codeOrFile);
        this.myOperationFnName = operationFnName;
    }

    public RunCustomOperationCommand(RemoteDebugger target, PyVariableLocator locator, String operationSource, String operationFnName) {
        this(target, locator, "EXEC", operationSource, operationFnName);
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        payload.add(this.myLocator.getPyDBLocation() + "||" + this.myStyle).add(this.myEncodedCodeOrFile).add(this.myOperationFnName);
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    private static String encode(String in) {
        return URLEncoder.encode(in, StandardCharsets.UTF_8);
    }
}

