#!/usr/bin/env python
# -*- mode: python; coding: utf-8; -*-
# ---------------------------------------------------------------------------##
#
# Copyright (C) 1998-2003 Markus Franz Xaver Johannes Oberhumer
# Copyright (C) 2003 Mt. Hood Playing Card Co.
# Copyright (C) 2005-2009 Skomoroh
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# ---------------------------------------------------------------------------##

from pysollib.games.mahjongg.mahjongg import r

# These Mahjongg layouts are "Lost" layouts from Flowersol, and were
# commented in previous versions of PySolFC.

# ************************************************************************
# * game definitions
# ************************************************************************

r(5600, "Eagle", layout="0cmadoacqaasbbmc" +
    "bocaedagdaudawdb" +
    "cebieakebmeboeaq" +
    "ebsebyeaefagfauf" +
    "awfbcgbigakgbmgb" +
    "ogaqgbsgbygaehag" +
    "hauhawhaaiacibmi" +
    "boiayiaAibejbwja" +
    "akackbmkbokaykaA" +
    "kaambkmanmbqmaAm" +
    "cioclocpocsoheeh" +
    "gehuehweheghgghu" +
    "ghwghbihzihbkhzk" +
    "omdoododeofeoheo" +
    "teoveoxeomfoofod" +
    "gofgohgotgovgoxg" +
    "omhoohobjomjoojo" +
    "zjvndveevgevuevw" +
    "evnfvegvggvugvwg" +
    "vnhvnjCfeCveCfgC" +
    "vg")
r(5601, "Five Pyramids 2", layout="0aoaaabacbaebagb" +
    "awbaybaAbaCbboca" +
    "adacdaedagdaidak" +
    "damdaqdasdaudawd" +
    "aydaAdaCdcoeaafa" +
    "cfaefagfawfayfaA" +
    "faCfamgdogaqgadh" +
    "azhagibiickidmid" +
    "oidqicsibuiawiad" +
    "jazjamkdokaqkaal" +
    "aclaelaglawlayla" +
    "AlaClcomaanacnae" +
    "nagnainaknamnaqn" +
    "asnaunawnaynaAna" +
    "Cnbooaapacpaepag" +
    "pawpaypaApaCpaoq" +
    "hbchdchfchxchzch" +
    "Bchbehdehfehxehz" +
    "ehBehbmhdmhfmhxm" +
    "hzmhBmhbohdohfoh" +
    "xohzohBoocdoedoy" +
    "doAdocnoenoynoAn")
r(5602, "H for Haga Traditional", layout="0acaaeaagaaiaaka" +
    "amaaoaaqaasaauaa" +
    "waayabgcbicakcam" +
    "caocaqcbscbucaee" +
    "bgebieakeameaoea" +
    "qebsebueaweacgae" +
    "gbggbigbkgbmgbog" +
    "bqgbsgbugawgayga" +
    "ahaAhaciaeibgibi" +
    "ibkibmiboibqibsi" +
    "buiawiayiaekbgkb" +
    "ikakkamkaokaqkbs" +
    "kbukawkbgmbimakm" +
    "ammaomaqmbsmbuma" +
    "coaeoagoaioakoam" +
    "oaooaqoasoauoawo" +
    "ayoklcknckpchdhh" +
    "xhklmknmkpm")
r(5603, "Hourglass", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaqaasaa" +
    "uaawaayaaacamcay" +
    "cacdawdaaeaeeame" +
    "aueayeacfagfasfa" +
    "wfaagaegaigamgaq" +
    "gaugaygachaghbkh" +
    "bohashawhaaiaeia" +
    "iiamiaqiauiayiac" +
    "jagjasjawjaakaek" +
    "amkaukaykaclawla" +
    "amammaymaaoacoae" +
    "oagoaioakoamoaoo" +
    "aqoasoauoawoayoh" +
    "abhmbhybhadhmdhy" +
    "dhcehwehafhefhuf" +
    "hyfhcghgghsghwgh" +
    "ahhehhihhqhhuhhy" +
    "hhcihgihsihwihaj" +
    "hejhujhyjhckhwkh" +
    "alhmlhylhanhmnhy" +
    "noacoycoaeoyeoag" +
    "oygoaioyioakoyko" +
    "amoymvadvydvafvy" +
    "fvahvyhvajvyjval" +
    "vylCaeCyeCagCygC" +
    "aiCyiCakCyk")
r(5604, "K for Kyodai Traditional", layout="0acaaeaagaaiaaka" +
    "amaaoaaqaasaauaa" +
    "waayaagcaicakcam" +
    "caocaqcascaucaee" +
    "ageaieakeameaoea" +
    "qeaseaueaweacgae" +
    "gaggaigakgamgaog" +
    "aqgasgaugawgayga" +
    "ahaAhaciaeiagiai" +
    "iakiamiaoiaqiasi" +
    "auiawiayiaekagka" +
    "ikakkamkaokaqkas" +
    "kaukawkagmaimakm" +
    "ammaomaqmasmauma" +
    "coaeoagoaioakoam" +
    "oaooaqoasoauoawo" +
    "ayokjckrckpdkjeh" +
    "gfknfhufkjghghkl" +
    "hhuhkjihgjknjhuj" +
    "kjkkplkjmkrm")
r(5605, "N for Namida Traditional", layout="0acaaeaagaaiaaka" +
    "amaaoaaqaasaauaa" +
    "waayacgcaicakcbm" +
    "ccoccqcasccucaee" +
    "cgecieakeameaoea" +
    "qeasecueaweacgae" +
    "gcggcigakgcmgaog" +
    "aqgasgcugawgayga" +
    "ahaAhaciaeicgiai" +
    "iakicmiaoicqiasi" +
    "cuiawiayiaekcgka" +
    "ikakkamkaokcqkas" +
    "kcukawkcgmaimckm" +
    "cmmbomaqmasmcuma" +
    "coaeoagoaioakoam" +
    "oaooaqoasoauoawo" +
    "ayoikfikhiohioji" +
    "sjisl")
r(5606, "Naoki Haga Traditional", layout="0acaaeaagaaiaaka" +
    "amaaoaaqaasaauaa" +
    "waayadgcaicakcdm" +
    "caocaqcascaucaee" +
    "dgeaiedkedmeaoec" +
    "qecseaueaweacgae" +
    "gdggaigakgdmgaog" +
    "aqgasgaugawgayga" +
    "ahaAhaciaeiagiai" +
    "iakiamidoiaqiasi" +
    "duiawiayiaekagkc" +
    "ikckkamkdokdqkds" +
    "kdukawkagmaimakm" +
    "ammdomaqmasmduma" +
    "coaeoagoaioakoam" +
    "oaooaqoasoauoawo" +
    "ayojidvrevjk")
r(5607, "Phoenix", layout="0aaaacaapaaraaEa" +
    "aGaaebatbaCbaaca" +
    "gcapcarcaAcaGcai" +
    "daydakeboebqebse" +
    "aweaafacfaefamfa" +
    "ufaCfaEfaGfaggbp" +
    "gbrgaAgaahaihamh" +
    "auhayhaGhaeiakic" +
    "picriawiaCiaajam" +
    "jaujaGjbpkbrkacl" +
    "aelaglailamlaula" +
    "ylaAlaClaElakmbp" +
    "mbrmawmacnafnamn" +
    "aunaBnaEnaioaooa" +
    "soayoacpafpaBpaE" +
    "pakqawqhbbhFbhdc" +
    "hDchfdhBdhhehzeh" +
    "jfhxfhdghlghvghD" +
    "ghfhhBhhhihnihti" +
    "hzihjjhxjhdkhlkh" +
    "vkhDkhflhnlhtlhB" +
    "lhhmhzmhjnhxnhlo" +
    "hvohnphtponfppfp" +
    "rfotfoplorlvqivq" +
    "lCqf")
r(5608, "Teotihucan", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaqaasaa" +
    "acascaaeaseaagcg" +
    "gckgcogasgaaicgi" +
    "ckicoiasiaakaska" +
    "amasmaaoacoaeoag" +
    "oaioakoamoaooaqo" +
    "asoajqhbbhdbhfbh" +
    "hbhjbhlbhnbhpbhr" +
    "bhbdhrdhbfhrfhbh" +
    "hrhhbjhrjhblhrlh" +
    "bnhdnhfnhhnhjnhl" +
    "nhnnhpnhrnhjpocc" +
    "oecogcoicokcomco" +
    "ocoqcoceoqeocgoq" +
    "gocioqiockoqkocm" +
    "oemogmoimokmommo" +
    "omoqmojovddvfdvh" +
    "dvjdvldvndvpdvdf" +
    "vffvhfvjfvlfvnfv" +
    "pfvdhwfhvhhwjhvl" +
    "hwnhvphvdjvfjvhj" +
    "vjjvljvnjvpjvdlv" +
    "flvhlvjlvllvnlvp" +
    "lvjn")
r(5609, "Tower and Walls", layout="0ekadmaeoadqaesa" +
    "dkccmccoccqcdscd" +
    "aeecedeeegedieek" +
    "ecmedoecqeesedue" +
    "ewedyeeAedCedkgc" +
    "mgcogcqgdsgekidm" +
    "ieoidqiesi")
r(5610, "What a Pyramid", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaqaasaa" +
    "uaawaaacaccbecbg" +
    "cbicbkcbmcbocbqc" +
    "bscaucawcaceaeeb" +
    "geciedkedmecoebq" +
    "easeaueaegbggdig" +
    "bkgbmgdogbqgasga" +
    "eibgidiibkibmido" +
    "ibqiasiackaekbgk" +
    "cikdkkdmkcokbqka" +
    "skaukaamacmbembg" +
    "mbimbkmbmmbombqm" +
    "bsmaumawmaaoacoa" +
    "eoagoaioakoamoao" +
    "oaqoasoauoawo")
r(5611, "Flowers 2", layout="0aaiacgbciackadc" +
    "adoaeiafabfcafea" +
    "fmbfoafqahcahoai" +
    "haijhjiakfakhakj" +
    "aklhlghlihlkamda" +
    "mfamhomhamjomjam" +
    "lamnhnehnghnivni" +
    "hnkhnmaobaodaofo" +
    "ofaohoohaojoojao" +
    "loolaonaophpchpe" +
    "hpgvpghpivpihpkv" +
    "pkhpmhpoaqbaqdoq" +
    "daqfoqfaqhoqhCqh" +
    "aqjoqjCqjaqloqla" +
    "qnoqnaqphrchrehr" +
    "gvrghrivrihrkvrk" +
    "hrmhroasbasdasfo" +
    "sfashoshasjosjas" +
    "loslasnasphtehtg" +
    "htivtihtkhtmauda" +
    "ufauhouhaujoujau" +
    "launhvghvihvkawf" +
    "awhawjawlhxiayha" +
    "yjazcazoaBabBcaB" +
    "eaBmbBoaBqaCiaDc" +
    "aDoaEgbEiaEkaGi")
r(5612, "Full Vision 3", layout="0aaeaagaaihbehbi" +
    "acbhccacdacfhcga" +
    "chacjhckaclacnhc" +
    "oacpaeahebaecaee" +
    "aegaeiaekhelaema" +
    "gbhgcagdagfhggag" +
    "hagjhgkaglagnhgo" +
    "agphhehhiaieaiga" +
    "iiainhioaiphjgak" +
    "eakgakiaknhkoakp" +
    "hlehliambhmcamda" +
    "mfhmgamhamjhmkam" +
    "lamnhmoampaoahob" +
    "aocaoehofaogaoia" +
    "okholaomaqbhqcaq" +
    "daqfhqgaqhaqjhqk" +
    "aqlaqnhqoaqphreh" +
    "riaseasgasiasnhs" +
    "oasphtgaueaugaui" +
    "aunhuoauphvehvia" +
    "wbhwcawdawfhwgaw" +
    "hawjhwkawlawnhwo" +
    "awpayahybaycayea" +
    "ygayiaykhylaymaA" +
    "bhAcaAdaAfhAgaAh" +
    "aAjhAkaAlaAnhAoa" +
    "AphBehBiaCeaCgaC" +
    "i")
r(5613, "Lion 2", layout="0aapabiablhbphcf" +
    "acghchhclacnocpa" +
    "djodladpvdpheeae" +
    "fheiaelvelhepCep" +
    "ofihflCflafnofph" +
    "gdagevgiagjoglag" +
    "pvgphhiChiahlvhl" +
    "hhpChphicaidoiih" +
    "ilCilainoipvjiaj" +
    "jojlajpvjpbkabkc" +
    "hkiCkiaklvklhkpC" +
    "kpolbolihllalnol" +
    "pbmabmcvmiamjoml" +
    "ampvmphnianlhnpo" +
    "oiholaonoophpfap" +
    "hapjappaqfhqiaql" +
    "hqphrdarnasehsqh" +
    "tcatpaudbumhuphv" +
    "bcvgavqawccwlhwq" +
    "hxbcxjaxpayccylh" +
    "yphzbczgazqaAdbA" +
    "mhAqhBcaBpaCehCp" +
    "hDeaDgaDohEgaEia" +
    "EmhEohFiaFkhFmhG" +
    "k")
# Contains floating tiles, so a usable tile may not be visible.
# Unplayable without serious work.
# r(5614, "New Layout 2", layout="0CabCadCafacapca" +
#     "hccvccacepcehcgv" +
#     "cgheaveaaecpeche" +
#     "eveeaegpegCfaCfc" +
#     "CfeCfgagapgahgcv" +
#     "gcagepgehggvggCh" +
#     "aChcCheChghiavia" +
#     "aicpichievieaigp" +
#     "igakaqkahkcwkcak" +
#     "eqkehkgwkghmawma" +
#     "amcqmchmewmeamgq" +
#     "mgaoaqoahocwocao" +
#     "eqoehogwoghqavqa" +
#     "aqcpqchqevqeaqgp" +
#     "qgCraCrcCreCrgas" +
#     "apsahscvscasepse" +
#     "hsgvsgCtaCtcCteC" +
#     "tghuavuaaucpuchu" +
#     "evueaugpugawapwa" +
#     "hwcvwcawepwehwgv" +
#     "wgCybCydCyf")
r(5615, "Big X", layout="0aacaamhbchbmacb" +
    "occacdaclocmacnh" +
    "dbhddhdlhdnaeaae" +
    "coedaeeaekoelaem" +
    "aeohfchfehfkhfma" +
    "gbagdogeagfagjog" +
    "kaglagnhhdhhfhhj" +
    "hhlaicaieoifaiga" +
    "iioijaikaimhjehj" +
    "ghjihjkakdakfokg" +
    "akhokiakjaklhlfh" +
    "lhhljameamgomgam" +
    "iomiamkhnfhnhhnj" +
    "aofoofaohoohaojo" +
    "ojhpfhphhpjaqeaq" +
    "goqgaqioqiaqkhrf" +
    "hrhhrjasdasfosga" +
    "shosiasjaslhteht" +
    "ghtihtkaucaueouf" +
    "augauioujaukaumh" +
    "vdhvfhvjhvlawbaw" +
    "doweawfawjowkawl" +
    "awnhxchxehxkhxma" +
    "yaaycoydayeaykoy" +
    "laymayohzbhzdhzl" +
    "hznaAboAcaAdaAlo" +
    "AmaAnhBchBmaCcaC" +
    "m")
r(5616, "Axis", layout="0bafcahbajbbdvbh" +
    "bblcchCchbdcvdhb" +
    "dmcehCehbfbvfhbf" +
    "ncghahaahohiahio" +
    "ajabjhajohkabkfb" +
    "kjhkoalabldbllal" +
    "ohmacmhhmoanaanc" +
    "vnhanmanoiobcohi" +
    "onapbwphapniqbcq" +
    "hiqnaraarcvrharm" +
    "arohsacshhsoatab" +
    "tdbtlatohuabufbu" +
    "jhuoavabvhavohwa" +
    "hwoaxaaxocyhbzbv" +
    "zhbzncAhCAhbBcvB" +
    "hbBmcChCChbDdvDh" +
    "bDlbEfcEhbEj")
r(5617, "Cobweb", layout="0aacaafhagaahoah" +
    "haiaajaamacbhcca" +
    "cdaclhcmacnadfhd" +
    "gadhodhhdiadjaea" +
    "aeohfaafcafeafha" +
    "fkafmhfoagaogaag" +
    "oogohhaahcahhahm" +
    "hhoaiaoiaaiooioh" +
    "jaajdajhajlhjoak" +
    "aakoalealhalkama" +
    "amoancanfhnganhh" +
    "nianjanmaoahoboo" +
    "gooihonaooopbapc" +
    "bpgvpgbpivpiapmo" +
    "pnaqahqboqgoqihq" +
    "naqoarcarfhrgarh" +
    "hriarjarmasaasoa" +
    "teathatkauaauohv" +
    "aavdavhavlhvoawa" +
    "owaawoowohxaaxca" +
    "xhaxmhxoayaoyaay" +
    "ooyohzaazcazeazh" +
    "azkazmhzoaAaaAoa" +
    "BfhBgaBhoBhhBiaB" +
    "jaCbhCcaCdaClhCm" +
    "aCnaEcaEfhEgaEho" +
    "EhhEiaEjaEm")
r(5618, "Pyramids", layout="0aaaaacaakaamhbb" +
    "abeabgabihblacaa" +
    "ccackacmhdbadead" +
    "gadihdlaeaaecaek" +
    "aemaffhfgafhahba" +
    "heahiahlhibhiehi" +
    "ihilajbojbajdoje" +
    "ajfajhojiajjajlo" +
    "jlhkbvkbhkevkehk" +
    "ghkivkihklvklalb" +
    "olbClbaldoleClea" +
    "lfolgalholiClial" +
    "jallollCllhmbvmb" +
    "hmevmehmgvmghmiv" +
    "mihmlvmlanbonbCn" +
    "bandoneCneanfong" +
    "anhoniCnianjanlo" +
    "nlCnlhobvobhoevo" +
    "ehoghoivoiholvol" +
    "apbopbapdopeapfa" +
    "phopiapjaploplhq" +
    "bhqehqihqlarbare" +
    "ariarlatfhtgatha" +
    "uaaucaukaumhvbav" +
    "eavgavihvlawaawc" +
    "awkawmhxbaxeaxga" +
    "xihxlayaaycaykay" +
    "m")
r(5619, "Wicker", layout="0bafbakbbcbbhbbm" +
    "bcebcjbdbbdgbdlb" +
    "edbeibenbfabffbf" +
    "kbgcbghbgmbhebhj" +
    "bibbigbilbjdbjib" +
    "jnbkabkfbkkblcbl" +
    "hblmbmebmjbnbbng" +
    "bnlbodboibonbpab" +
    "pfbpkbqcbqhbqmbr" +
    "ebrjbsbbsgbslbtd" +
    "btibtnbuabufbukb" +
    "vcbvhbvmbwebwjbx" +
    "bbxgbxlbydbyibyn" +
    "bzfbzkbAh")

r(5620, "Big Square", name="Double Mahjongg Big Square", ncards=288,
  layout="0daadacdaedagdai" +
    "dakdcadccdcedcgd" +
    "cidckdeadecdeede" +
    "gdeidekdgadgcdge" +
    "dggdgidgkdiadicd" +
    "iedigdiidikdkadk" +
    "cdkedkgdkidkkdma" +
    "dmcdmedmgdmidmkd" +
    "oadocdoedogdoido" +
    "kdqadqcdqedqgdqi" +
    "dqkdsadscdsedsgd" +
    "sidskduaducduedu" +
    "gduidukdwadwcdwe" +
    "dwgdwidwk")
r(5621, "Rows", name="Double Mahjongg Rows", ncards=288,
  layout="0daadacCaddaeCaf" +
    "dagCahdaidakdcad" +
    "ckeeadeceeeeegde" +
    "ieekegaegkeiadic" +
    "eieeigdiieikekae" +
    "kkemadmcemeemgdm" +
    "iemkeoaeokeqadqc" +
    "eqeeqgdqieqkesae" +
    "skeuaduceueeugdu" +
    "ieukewaewkeyadyc" +
    "eyeeygdyieykdAad" +
    "AkdCadCcCCddCeCC" +
    "fdCgCChdCidCk")
r(5622, "K 2", name="Half Mahjongg K 2", ncards=72,
  layout="0aagabcabehbfobg" +
    "hbhabiabkacgvcga" +
    "dbidgadlaegvegbf" +
    "aifgbfmaggbhaihg" +
    "bhmaigbjahjgbjma" +
    "kgokgblahlgblmam" +
    "gbnaingbnmaogbpa" +
    "ipgbpmaqgvqgarbi" +
    "rgarlasgvsgatcat" +
    "ehtfotghthatiatk" +
    "aug")
r(5623, "Abstract", name="Half Mahjongg Abstract", ncards=72,
  layout="0aaaaagabcabebdd" +
    "adgadioedhehafch" +
    "fdafeafhagahhaah" +
    "dahgaiahjaojbbjc" +
    "ajfakaalcamfamha" +
    "nbhncandhngaogbo" +
    "iapdhqdaqiarcord" +
    "arehrihsdasgasia" +
    "tdauaaufhvbavcav" +
    "iawaawehxeaxiayc" +
    "ayebyghzdaAdaAha" +
    "BbaBfhCfaCiaDcaD" +
    "eaDghDhaEaaEi")
