# Interface for submodule: PyImageFilter
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: PyImageFilter
from ._proxies import PyImageFilterProxy as _PyImageFilterProxy
class _PyImageFilterTemplateGetter():
    def __getitem__(self, parameters) -> _PyImageFilterTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: PyImageFilterTemplate
            """
        ...


class _PyImageFilterTemplate(_itkTemplate, metaclass=_PyImageFilterTemplateGetter):
    """Interface for instantiating itk::PyImageFilter< INSERT_TYPE_NAMES_HERE >
        Create a new PyImageFilter Object (of default type):
            'itk.PyImageFilter.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.PyImageFilter[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _PyImageFilterProxy:
        """Instantiate itk::PyImageFilter< INSERT_TYPE_NAMES_HERE >"""
        ...

PyImageFilter = _PyImageFilterTemplate

