\name{ImageViewer}
\alias{ImageViewer}
\title{ImageViewer}
\Rdversion{1.1}
\docType{class}
\description{
Display an image in an external viewer (Fiji by default)
ImageViewer}
\details{
The ImageViewer class displays an image with an external image display application.
By default the class will search for a Fiji executable. The image is written out to a temporary file and then
passed to the application.
When the first ImageViewer object is constructed the following environment variables are queried
to set up the external viewer:
SITK_SHOW_EXTENSION: file format extension of the temporary image
file. The default is '.mha', the MetaIO file format.
SITK_SHOW_COMMAND: The user can specify an application other than Fiji
to view images.
The environment variables are not checked for subsequent ImageViewer objects.
ImageViewer}
%C++ includes: sitkImageViewer.h
\section{Methods}{
\describe{
\item{void Execute(const Image &image):}{
Launch the viewing application to display the given image.
}
\item{const std::string & GetApplication() const:}{
Get the full path to the viewing application used in the command
string.
}
\item{const std::string & GetCommand() const:}{}
\item{std::string GetName() const:}{
Return the user readable name of the class
}
\item{ ImageViewer():}{}
\item{void SetApplication(const std::string &app, const std::string &command="\%a \%f"):}{
Set the full path to the viewing application used in the command
string.
The SetApplication method expects the app parameter to be a full path name to the display application's
executable. For instance, on Windows when using Fiji, one would use
the full path to the ImageJ-win64.exe such as:'C:\\\\Users\\\\dave\\\\Fiji.app\\\\ImageJ-win64.exe'
On Linux, app would be set to something like:'/home/dave/bin/Fiji.app/ImageJ-linux64'
Using this method overrides the default application search.
By default, when this method is called, the command string is set to "\%a \%f" which simply means the application path followed by the temporary image file.
}
\item{void SetCommand(const std::string &command):}{
Set the command string used to launch the viewing application.
This command string may include the following tokens:
'a' for the image viewing application (Fiji by default)
'f' for SimpleITK's temporary image file
 For example, the default command string on Linux systems is:
After token substitution it may become:
For another example, the default command string on Mac OS X is:
After token substitution the string may become:
The string after '-eval' is an ImageJ macro the opens the file and sets the title of the
window.
If the 'f' token is not found in the command string, the temporary file name is
automatically appended to the command argument list.
Note: Using the ImageViewer::SetCommand method overrides the default command and/or the SITK_SHOW_COMMAND
environment variable.
}
\item{std::string ToString() const:}{
Print ourself out to a string.
}
}
}
