% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(DiskLight)=
# DiskLight

An intrinsic light that emits light from a circular
disk centered in the XY plane. The light is emitted from one side of the disk
along the -Z axis.

Use DiskLights to illuminate objects, simulating soft boxes used in photography, 
linear lights, fluorescent lights, and light panels. 

The following simple example has a DiskLight positioned near a Sphere and Cube,
with a radius of 0.8 and an intensity of 20.

```{code-block} usda
#usda 1.0
(
    upAxis = "Y"
)

def Scope "Lights"
{
    def DiskLight "Light1"
    {

        float inputs:radius = 0.8 

        color3f inputs:color = (1, 1, 1)
        float inputs:intensity = 20.0
        double3 xformOp:translate = (4, 0, 1)
        uniform token[] xformOpOrder = ["xformOp:translate"]
    }
}

def Xform "TestGeom"
{
    def Sphere "Sphere1"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double3 xformOp:translate = (0, 0, -2)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }

    def Cube "Cube"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double size = 8
        double3 xformOp:translate = (0, 0, -8)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }
}
```

Example RenderMan output for this layer:

```{image} lux_disk_light.png
:alt: Example DiskLight
:width: 600px
```


```{contents}
:depth: 2
:local:
:backlinks: none
```

(DiskLight_properties)=

## Properties

(DiskLight_inputs:radius)=

### inputs:radius

**USD type**: `float`

**Fallback value**: `0.5`

Radius of the disk. A larger radius increases
the overall reach of the light. 


(DiskLight_light:shaderId)=

### light:shaderId

**USD type**: `token`

**Fallback value**: `DiskLight`

The shader ID for a DiskLight. 
USD will also register a Sdr shader node with a "DiskLight" identifier and 
the source type "USD" to correspond to the light's inputs


(DiskLight_inheritedproperties_Boundable)=

## Inherited Properties ({ref}`Boundable`)

(DiskLight_extent)=

### extent

**USD type**: `float3[]`



(DiskLight_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(DiskLight_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(DiskLight_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(DiskLight_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(DiskLight_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(DiskLight_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


