% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(DistantLight)=
# DistantLight

An intrinsic light that provides light from
a distant source, along the -Z axis. Also known as a "directional light".
Typically used for distant, broad sources of light, like sunlight, where light
rays affect the entire scene and are roughly parallel (depending on 
`inputs:angle`). 

The following example uses a DistantLight with a increased `inputs:angle` of
1.0 (noticeably broadening the light spread, but softening the shadow), and 
reduces the intensity from the default 50000 to 10000.

```{code-block} usda
#usda 1.0
(
    upAxis = "Y"
)

def Scope "Lights"
{
    def DistantLight "Light1"
    {
        float inputs:angle = 1.0 
        float inputs:intensity = 10000
    }
}

def Xform "TestGeom"
{
    def Sphere "Sphere1"
    {
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double3 xformOp:translate = (0, 0, -2)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }

    def Cube "Cube"
    {
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double size = 8
        double3 xformOp:translate = (0, 0, -8)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }
}
```

Example RenderMan output for this layer:

```{image} lux_distant_light.png
:alt: Example DistantLight
:width: 600px
```

```{contents}
:depth: 2
:local:
:backlinks: none
```

(DistantLight_properties)=

## Properties

(DistantLight_inputs:angle)=

### inputs:angle

**USD type**: `float`

**Fallback value**: `0.5299999713897705`

Sets the angular diameter of the DistantLight in
degrees. The fallback value is 0.53, which approximates the 0.53 degree
angular size of the Sun as seen from Earth. 

Higher values soften the shadow edges (light rays become less parallel) while 
lower values make it sharper. Larger values increase shadow softness by 
increasing the angle of its light. 

This value is assumed to be in the range `0 <= angle < 360`, and will be clipped 
to this range. Note that this implies that we can have a distant light emitting 
from more than a hemispherical area of light if angle > 180. While this is 
valid, it is possible that for large angles a DomeLight may provide better 
performance.

Increasing this parameter also increases the amount of light in the scene and 
you may need to reduce the light intensity/exposure to compensate.


(DistantLight_inputs:intensity)=

### inputs:intensity

**USD type**: `float`

**Fallback value**: `50000.0`

Scales the brightness of the light 
linearly. The fallback value of 50000 provides a high intensity to approximate
sunlight.

Expresses the "base", unmultiplied luminance emitted (L) of the light,
in nits (cd∕m²):

```{math}
L_{Scalar} = intensity
```

Normatively, the lights' emission is in units of spectral radiance
normalized such that a directly visible light with `intensity` 1 and
`exposure` 0 normally incident upon the sensor plane will generate a
pixel value of [1, 1, 1] in an RGB renderer, and thus have a luminance
of 1 nit. A light with `intensity` 2 and `exposure` 0 would therefore
have a luminance of 2 nits.


(DistantLight_light:shaderId)=

### light:shaderId

**USD type**: `token`

**Fallback value**: `DistantLight`

The shader ID for a DistantLight. 
USD will also register a Sdr shader node with a "DistantLight" identifier and 
the source type "USD" to correspond to the light's inputs


(DistantLight_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(DistantLight_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(DistantLight_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(DistantLight_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(DistantLight_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(DistantLight_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


