% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(LightAPI)=
# LightAPI

When this schema is applied to a prim, that prim
gains the capabilities of being a light. These capabilities include light 
attributes such as light color, intensity, specular and diffuse multipliers, 
etc. This schema also provides more advanced configuration such as specifying
how geometry is associated with the light through 
{ref}`light-linking <usdLux_light_linking>` or how 
{ref}`light filters <usdLux_light_filters>` are applied.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(LightAPI_properties)=

## Properties

(LightAPI_collection:lightLink:includeRoot)=

### collection:lightLink:includeRoot

**USD type**: `bool`

**Fallback value**: `True`

Use the lightLink collection to specify which
geometry is associated with this light. This collection is used to control
light behavior associated with the geometry collection, such as which geometry
prims are illuminated by this light, via a feature called 
{ref}`light-linking <usdLux_light_linking>`.

The `includeRoot` attribute indicates whether the pseudo-root path `/` should 
be counted as one of the included target paths. Note that the fallback value 
is true, which means that lights will illuminate all objects.

See {ref}`usdLux_light_linking` for more details on light-linking, and
{ref}`collections_and_patterns` for more details on USD collections.


(LightAPI_collection:shadowLink:includeRoot)=

### collection:shadowLink:includeRoot

**USD type**: `bool`

**Fallback value**: `True`

Use the shadowLink collection to specify which
geometry is associated with this light. This collection is used to control
lighting shadow behavior associated with the geometry collection, such as 
whether the associated geometry prims should cast shadows for this light, via a 
feature called {ref}`light-linking <usdLux_light_linking>`.

The `includeRoot` attribute indicates whether the pseudo-root path `/` should 
be counted as one of the included target paths. Note that the fallback value 
is true, which means that lights will cast shadows for all objects.

See {ref}`usdLux_light_linking` for more details on light-linking, and
{ref}`collections_and_patterns` for more details on USD collections.

(LightAPI_inputs:color)=

### inputs:color

**USD type**: `color3f`

**Fallback value**: `(1, 1, 1)`

Specifies the light color, in the rendering
color space. This color is just multiplied with the emission:

```{math}
L_{Color} = L_{Scalar} \cdot color
```


(LightAPI_inputs:colorTemperature)=

### inputs:colorTemperature

**USD type**: `float`

**Fallback value**: `6500.0`

Specifies the color temperature in degrees
Kelvin, representing the white point. Lower values are warmer and higher values
are cooler, with a valid range from 1000 to 10000. Setting color temperature
allows the user to easily pick plausible light colors based on standard 
temperature measurements. 

Only takes effect when `enableColorTemperature` is true.

The fallback value, 6500, matches the "D65" common standard white point.

This is always calculated as an RGB color using a D65 white point, regardless of 
the rendering color space, normalized such that the fallback value of 6500 will 
always result in white, and then should be transformed to the rendering color 
space.

See {ref}`usdLux_light_contributions` for examples of different 
colorTemperature values.


(LightAPI_inputs:diffuse)=

### inputs:diffuse

**USD type**: `float`

**Fallback value**: `1.0`

Controls the light's diffuse contribution. This 
is a non-physical control.

(LightAPI_inputs:enableColorTemperature)=

### inputs:enableColorTemperature

**USD type**: `bool`

**Fallback value**: `False`

Used to enable or disable using 
`colorTemperature` in lighting calculations.

(LightAPI_inputs:exposure)=

### inputs:exposure

**USD type**: `float`

**Fallback value**: `0.0`

Scales the brightness of the light exponentially 
as a power of 2 (similar to an F-stop control over exposure). The result
is multiplied against `intensity`:

```{math}
L_{Scalar} = L_{Scalar} \cdot 2^{exposure} 
```

Normatively, the lights' emission is in units of spectral radiance
normalized such that a directly visible light with `intensity` 1 and
`exposure` 0 normally incident upon the sensor plane will generate a
pixel value of [1, 1, 1] in an RGB renderer, and thus have a luminance
of 1 nit (cd∕m²). A light with `intensity` 1 and `exposure` 2 would
therefore have a luminance of 4 nits.

Exposure is intended to behave similarly to photographic exposure measurements. 
See {ref}`usdLux_light_contributions` for examples of how exposure contributes 
to lighting calculations.

(LightAPI_inputs:intensity)=

### inputs:intensity

**USD type**: `float`

**Fallback value**: `1.0`

Scales the brightness of the light linearly, 
using physical falloff. 

Expresses the "base", unmultiplied luminance emitted (L) of the light,
in nits (cd∕m²):

```{math}
L_{Scalar} = intensity
```

Normatively, the lights' emission is in units of spectral radiance normalized 
such that a directly visible light with `intensity` 1 and`exposure` 0 normally 
incident upon the sensor plane will generate a pixel value of [1, 1, 1] in an 
RGB renderer, and thus have a luminance of 1 nit. A light with `intensity` 2 and 
`exposure` 0 would therefore have a luminance of 2 nits.

See {ref}`usdLux_light_contributions` for examples of how intensity contributes 
to lighting calculations.

(LightAPI_inputs:normalize)=

### inputs:normalize

**USD type**: `bool`

**Fallback value**: `False`

Normalizes the emission of the light such that,
if enabled, the power of the light remains constant while altering the size of 
the light, by dividing the luminance by the world-space surface area of the 
light.

This makes it easier to independently adjust the brightness and size of the 
light, by causing the total illumination provided by a light to not vary with 
the area or angular size of the light.

Mathematically, this means that the luminance of the light will be divided by a 
"sizeFactor" representing the "size" of the light:

```{math}
L_{Scalar} = L_{Scalar} / sizeFactor 
```

where *sizeFactor* = 1 if `normalize` is off, and is calculated depending on the 
family of the light as described below if `normalize` is on.

**DomeLight / PortalLight**

This attribute is ignored for DomeLights (all versions) and PortalLights, and 
therefore sizeFactor is always treated as 1.

**Area lights**

sizeFactor is the surface area (in world space) of the shape of the light, 
including any scaling applied to the light by its transform stack. The 
boundable light types which have a calculable surface area are:

- MeshLightAPI
- DiskLight
- RectLight
- SphereLight
- CylinderLight

```{math}
sizeFactor_{area} = worldSpaceSurfaceArea(light)
```

**Distant Lights**

For DistantLights, we first define 𝛳<sub>max</sub> as:
 
```{math}
\theta_{max} = clamp(toRadians(distantLightAngle) / 2, 0, \pi)
```

Then we use the following formula:

```{math}
sizeFactor_{distant} =
\begin{cases}
    1,                                & \text{if} \quad \theta_{max} = 0              \\
    sin(\theta_{max})^2 * \pi,        & \text{if} \quad 0<\theta_{max} \leq \pi / 2   \\
    ( 2 - sin(\theta_{max})^2) * \pi, & \text{if} \quad \pi/2 < \theta_{max} \leq \pi
\end{cases}
```

This formula is used because it satisfies the following two properties:

1. When normalize is enabled, the received illuminance from this light on a 
surface normal to the light's primary direction is held constant when the angle 
changes, and the `intensity` property becomes a measure of the illuminance, 
expressed in lux, for a light with 0 `exposure`.
2. If we assume that our distant light is an approximation for a "very far" 
sphere light (like the sun), then (for *0 < 𝛳<sub>max</sub> ≤ 𝜋/2*) this 
definition agrees with the definition used for area lights -- i.e., the total 
power of this distant sphere light is constant when the "size" (i.e., angle) 
changes, and our sizeFactor is proportional to the total surface area of this 
sphere.    

**Other/custom lights**

Lights from other third-party plugins / schemas must document their own expected 
behavior with regards to normalize. 


(LightAPI_inputs:specular)=

### inputs:specular

**USD type**: `float`

**Fallback value**: `1.0`

Controls the light's specular contribution. 
This is a non-physical control.

(LightAPI_light:filters)=

### light:filters

**USD type**: `rel` (relationship)

Use filters to modulate the effects of the
light. Light filters use shaders to create custom light effects.
See {ref}`usdLux_light_filters` for more details on light filters.


(LightAPI_light:materialSyncMode)=

### light:materialSyncMode

**USD type**: `token`

**Fallback value**: `noMaterialResponse`

When LightAPI is applied to geometry that has a 
bound Material which is entirely or partly emissive, this attribute specifies
the relationship of the Material response to the lighting response. Valid 
values are:
- `materialGlowTintsLight`: All primary and secondary rays see the 
  emissive/glow response as dictated by the bound Material while the 
  base color seen by light rays (which is then modulated by all of the 
  other LightAPI controls) is the multiplication of the color feeding 
  the emission/glow input of the Material with the scalar or pattern input 
  to `inputs:color`. This allows the light's color to tint the geometry's glow 
  color while preserving access to intensity and other light controls as ways to 
  further modulate the illumination.
- `independent`: All primary and secondary rays see the emissive/glow 
  response as dictated by the bound Material, while the base color seen 
  by light rays is determined solely by `inputs:color`. Note that for 
  partially emissive geometry (in which some parts are reflective 
  rather than emissive), a suitable pattern must be connected to the 
  light's color input, or else the light will radiate uniformly from 
  the geometry.
- `noMaterialResponse`: The geometry behaves as if there is no Material
  bound at all, i.e. there is no diffuse, specular, or transmissive 
  response. The base color of light rays is entirely controlled by the
  `inputs:color`. This is the fallback value.  

See {ref}`usdLux_light_contributions` for an example using the different
materialSyncMode values.


(LightAPI_light:shaderId)=

### light:shaderId

**USD type**: `token`

**Fallback value**: ``


This defines the shader ID for this light when a render context specific
shader ID is not available.

For intrinsic lights (RectLight, DistantLight, etc.), the shader ID is by
default set to the light's type name. USD will also register a Sdr shader node
with a matching identifier and the source type "USD" to correspond to the 
light's inputs.
.
