% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(LightListAPI)=
# LightListAPI

Use this schema to discover lights in a scene 
during traversal. LightListAPI provides the following capabilities:

- Gather a list of lights in the scene. Use ComputeLightList()
(with a ComputeModeIgnoreCache) to traverse and gather lights (e.g. prims with
the LightAPI schema applied). The following Python example uses 
ComputeLightList() to get all lights descendant from `</World>`.

```{code} python
listAPI = UsdLux.LightListAPI(stage.GetPrimAtPath("/World"))
ignoreCache = UsdLux.LightListAPI.ComputeModeIgnoreCache
computedLights = listAPI.ComputeLightList(ignoreCache)
for lightPath in computedLights:
    ...process light path...
```

- Creating and using a cached light list. You may want to get a list of lights
but defer loading payloads and traversing the entire scene if possible. 
LightListAPI allows for computing or specifying a cached light list, letting
you pay an upfront cost of computing or authoring the cache in scenarios 
where you want a faster traversal. 

To compute and publish the cache, you first use ComputeLightList() with
ComputeModeIgnoreCache as we did in the previous example, and then use
StoreLightList() to cache the light list on a model hierarchy prim.

```{code} python
listAPI = UsdLux.LightListAPI(stage.GetPrimAtPath("/World"))
ignoreCache = UsdLux.LightListAPI.ComputeModeIgnoreCache
computedLights = listAPI.ComputeLightList(ignoreCache)
# Cache computed list
listAPI.StoreLightList(computedLights)
```

This adds a `lightList` relationship to the model hierarchy prim the
LightListAPI was bound to. Alternatively, you can author this list in
your model hierarchy prim directly:

```{code}
def Xform "LightModel"
(
    kind = "model"
    prepend apiSchemas = ["LightListAPI"]
)
{
    # cached list of lights
    rel lightList = [
        </Lights/Light1>,
        </Lights/Light2>,
    ]
    token lightList:cacheBehavior = "consumeAndContinue"
}
```

To enable efficient retrieval of the cache, it should be stored on a model 
hierarchy prim. Furthermore, while you can use a LightListAPI bound to the 
pseudo-root prim to query the lights you cannot store the cache back to the
pseduo-root prim.

`cacheBehavior` provides a way to add more fine-grained control to how the 
cache is consulted. See {ref}`LightListAPI_lightList:cacheBehavior` for more 
details.

When instances are present, ComputeLightList() will return instance-unique 
paths to any lights discovered within those instances. Lights within a 
PointInstancer will not be returned, as they cannot be referred to solely
via paths.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(LightListAPI_properties)=

## Properties

(LightListAPI_lightList)=

### lightList

**USD type**: `rel` (relationship)

The cached light list, either computed and
stored, or authored. Must be authored on a model hierarchy prim. A simple 
example might look like the following.

```{code}
def Xform "LightModel"
(
    kind = "model"
    prepend apiSchemas = ["LightListAPI"]
)
{
    rel lightList = [
        </Lights/Light1>,
        </Lights/Light2>,
    ]
}
```

If lightList is empty, this represents a cached list that specifies that *no*
lights are present.


(LightListAPI_lightList:cacheBehavior)=

### lightList:cacheBehavior

**USD type**: `token`

When using a light list cache via 
ComputeLightList(), this property controls how the light list should be 
interpreted. Valid values and behaviors are:
- "consumeAndHalt": The lightList should be consulted, and if it exists, treated 
as a final authoritative statement of any lights that exist at or below this 
prim, halting recursive discovery of lights. No descendant prims will be 
examined.
- "consumeAndContinue": The lightList cache should be consulted to contribute
lights to the traversal, and recursion should continue down the model 
hierarchy in case additional lights are added as descendants. This is the 
default value established when StoreLightList() is invoked. This behavior allows 
the lights within a large model to be published outside the payload, while also 
allowing referencing and layering to add additional lights over that set.
- "ignore": indicates that the lightList should be disregarded. This provides a 
way to invalidate cache entries. Note that unless "ignore" is specified, a 
lightList with an empty list of targets is considered a cache indicating that no 
lights are present.

