% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(RectLight)=
# RectLight

An intrinsic light that emits light from one side 
of a rectangle.  The rectangle is centered in the XY plane and emits light
along the -Z axis. The rectangle is 1 unit in length in the X and Y axis.

Use RectLights to illuminate objects, simulating soft boxes used in photography, 
linear lights, fluorescent lights, and light panels. 

The following simple example has a RectLight positioned near a Sphere and Cube,
with a width/height of 5x5, and using a colored checkerboard texture as a 
color map (with additional adjustments to light shaping cone angle and focus to
limit the light spread).

```{code-block} usda
#usda 1.0
(
    upAxis = "Y"
)

def Scope "Lights"
{
    def RectLight "Light1"
    {
        float inputs:width = 5
        float inputs:height = 5
        asset inputs:texture:file = @checkerboard.png@

        color3f inputs:color = (1, 1, 1)
        float inputs:intensity = 5.0
        float3 xformOp:rotateXYZ = (0, 90, 0)
        double3 xformOp:translate = (3.5, 0, -1)
        uniform token[] xformOpOrder = ["xformOp:translate", "xformOp:rotateXYZ"]        
    }
}

def Xform "TestGeom"
{
    def Sphere "Sphere1"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double3 xformOp:translate = (0, 0, -2)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }

    def Cube "Cube"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double size = 8
        double3 xformOp:translate = (0, 0, -8)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }
}
```

Example RenderMan output for this layer:

```{image} lux_rect_light.png
:alt: Example RectLight
:width: 600px
```


```{contents}
:depth: 2
:local:
:backlinks: none
```

(RectLight_properties)=

## Properties

(RectLight_inputs:height)=

### inputs:height

**USD type**: `float`

**Fallback value**: `1.0`

The height of the rectangle in 
the local Y axis.


(RectLight_inputs:texture:file)=

### inputs:texture:file

**USD type**: `asset`

A color texture set on the rectangle that can
act as a color map for the emitted light. In the default position, a texture 
file's min coordinates should be at (+X, +Y) and max coordinates at (-X, -Y).


(RectLight_inputs:width)=

### inputs:width

**USD type**: `float`

**Fallback value**: `1.0`

The width of the rectangle in the local
X axis.


(RectLight_light:shaderId)=

### light:shaderId

**USD type**: `token`

**Fallback value**: `RectLight`

The shader ID for a RectLight. 
USD will also register a Sdr shader node with a "RectLight" identifier and 
the source type "USD" to correspond to the light's inputs


(RectLight_inheritedproperties_Boundable)=

## Inherited Properties ({ref}`Boundable`)

(RectLight_extent)=

### extent

**USD type**: `float3[]`



(RectLight_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(RectLight_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(RectLight_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(RectLight_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(RectLight_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(RectLight_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


