% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(ShapingAPI)=
# ShapingAPI

Use this schema to control the shaping of a light's
emission. This includes controlling the light spread, light cone settings, etc.

See {ref}`usdLux_shaping` for more examples of using ShapingAPI.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(ShapingAPI_properties)=

## Properties

(ShapingAPI_inputs:shaping:cone:angle)=

### inputs:shaping:cone:angle

**USD type**: `float`

**Fallback value**: `90.0`

Angular limit off the primary axis to restrict 
the light spread, in degrees. Smaller angles can create a light "cone" used to
make the light behave as a spot light. 

Light emissions at angles off the primary axis greater than this are
guaranteed to be zero:

```{math}
\begin{aligned} 
&𝛳_{offAxis} = acos(lightAxis • emissionDir) \\
&𝛳_{cutoff} = toRadians({coneAngle}) \\
&𝛳_{offAxis} > 𝛳_{cutoff} ⟹ L_{Scalar} = 0
\end{aligned} 
```
For angles < coneAngle, behavior is determined by `shaping:cone:softness`.
At the default of coneSoftness = 0, the luminance is unaltered if the 
emissionOffAxisAngle <= coneAngle, so the coneAngle functions as a hard binary 
"off" toggle for all angles > coneAngle.

Note that this attribute does not affect IES profiles (if any are applied for 
this light). 


(ShapingAPI_inputs:shaping:cone:softness)=

### inputs:shaping:cone:softness

**USD type**: `float`

**Fallback value**: `0.0`

The cutoff softness for cone angle. In most 
cases you'll use a value in the range from 0 (hard cut-off) to 1 (smooth 
transition), but you can use values higher than 1 for additional gradation. 

At the fallback value of coneSoftness = 0, the luminance is unaltered if the
emissionOffAxisAngle <= coneAngle, and 0 if emissionOffAxisAngle > coneAngle, 
so in this situation the coneAngle functions as a hard binary "off" toggle for 
all angles > coneAngle.

For coneSoftness in the range (0, 1], it defines the proportion of the
non-cutoff angles over which the luminance is smoothly interpolated from
0 to 1. Mathematically:

```{math}
\begin{aligned} 
&𝛳_{offAxis} = acos(lightAxis • emissionDir) \\
&𝛳_{cutoff} = toRadians(coneAngle) \\
&𝛳_{smoothStart} = lerp(coneSoftness, 𝛳_{cutoff}, 0) \\
\\
&L_{Scalar} = L_{Scalar} ⋅ (1 - smoothStep(𝛳_{offAxis},𝛳_{smoothStart},𝛳_{cutoff})
\end{aligned} 
```

Values outside of the [0, 1] range are clamped to the range.


(ShapingAPI_inputs:shaping:focus)=

### inputs:shaping:focus

**USD type**: `float`

**Fallback value**: `0.0`

Use focus to shape the spread of the light. 
A higher focus value pulls light towards the center, effectively narrowing the
spread. Values < 0 are ignored.

This is implemented as a multiplication with the absolute value of the dot 
product between the light's surface normal and the emission direction, raised to 
the power `focus`. See {ref}`inputs:shaping:focusTint <ShapingAPI_inputs:shaping:focusTint>`
for the complete formula, but if we assume a default `focusTint` of pure black, 
then that formula simplifies to:

```{math}
\begin{aligned} 
&focusFactor = ｜emissionDirection • lightNormal｜^{focus} \\
&L_{Color} = focusFactor ⋅ L_{Color}
\end{aligned} 
```


(ShapingAPI_inputs:shaping:focusTint)=

### inputs:shaping:focusTint

**USD type**: `color3f`

**Fallback value**: `(0, 0, 0)`

Use focusTint to set the color tint of the
emission of the light in the falloff region. This tints the emission in the 
falloff region starting from the off-angle direction of the light towards the 
center.

This is implemented as a linear interpolation between `focusTint` and
white, by the factor computed from the focus attribute, in other words:

```{math}
\begin{aligned} 
&focusFactor = ｜emissionDirection • lightNormal｜^{focus} \\
&focusColor = lerp(focusFactor, focusTint, [1, 1, 1]) \\
&L_{Color} = componentwiseMultiply(focusColor, L_{Color}) 
\end{aligned}
```

Note that this implies that a focusTint of pure white will disable
focus.


(ShapingAPI_inputs:shaping:ies:angleScale)=

### inputs:shaping:ies:angleScale

**USD type**: `float`

**Fallback value**: `0.0`

Applies a scaling factor to the latitudinal 
theta/vertical polar coordinate before sampling the IES profile, to shift the 
samples more toward the "top" or "bottom" of the profile. The scaling origin 
varies depending on whether `angleScale` is positive or negative.  If it is
positive, the scaling origin is theta = 0; if it is negative, the scaling origin 
is theta = pi (180 degrees).  Values where |angleScale| < 1 will "shrink" the 
angular range in which the iesProfile is applied, while values where 
|angleScale| > 1 will "grow" the angular range to which the iesProfile is mapped.

If <i>𝛳<sub>light</sub></i> is the latitudinal theta polar coordinate of the 
emission direction in the light's local space, and <em>𝛳<sub>ies</sub></em> is 
the value that will be used when actually sampling the profile, then the exact 
formula is:

```{math}
\begin{aligned}
&if \quad angleScale > 0: \\
& \quad 𝛳_{ies} = 𝛳_{light} / angleScale \\
&if \quad angleScale = 0: \\
& \quad 𝛳_{ies} = 𝛳_{light} \\
&if \quad angleScale < 0: \\
& \quad 𝛳_{ies} = (𝛳_{light} - π) / -angleScale
\end{aligned}
```

See {ref}`usdLux_anglescale_best_practices` for best practices when using 
angleScale.



(ShapingAPI_inputs:shaping:ies:file)=

### inputs:shaping:ies:file

**USD type**: `asset`

An Illumination Engineering Society (IES) light
profile describing the angular distribution of light.

For full details on the .ies file format, see the full specification,
[ANSI/IES LM-63-19](https://store.ies.org/product/lm-63-19-approved-method-ies-standard-file-format-for-the-electronic-transfer-of-photometric-data-and-related-information/)

The luminous intensity values in the IES profile are sampled using the emission 
direction in the light's local space (after a possible transformation by a 
non-zero `shaping:ies:angleScale`, see below). The sampled value is then 
potentially normalized by the overall power of the profile if 
`shaping:ies:normalize` is enabled, and then used as a scaling factor on the 
returned luminance:

```{math}
\begin{aligned}
&𝛳_{light}, 𝜙 = toPolarCoordinates(emissionDirectionInLightSpace) \\
&𝛳_{ies} = applyAngleScale(𝛳_{light}, angleScale) \\
&iesSample = sampleIES(iesFile, 𝛳_{ies}, 𝜙) \\
&iesNormalize ⟹ iesSample = iesSample ⋅ iesProfilePower(iesFile) \\
\\
&L_{Color} = iesSample ⋅ L_{Color}
\end{aligned}
```

See {ref}`inputs:shaping:ies:angleScale <ShapingAPI_inputs:shaping:ies:angleScale>`
for a description of `applyAngleScale`, and 
{ref}`inputs:shaping:ies:normalize <ShapingAPI_inputs:shaping:ies:normalize>` 
for how `iesProfilePower` is calculated.


(ShapingAPI_inputs:shaping:ies:normalize)=

### inputs:shaping:ies:normalize

**USD type**: `bool`

**Fallback value**: `False`

Normalizes the IES profile to affect
the shaping of the light while preserving the overall energy output.
Used to prevent the IES profile amplitude from altering the energy of the light.

The sampled luminous intensity is scaled by the overall power of the
IES profile if this is on, where the total power is calculated by
integrating the luminous intensity over all solid angle patches
defined in the profile.

