% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 11:28PM on April 14, 2025


(SphereLight)=
# SphereLight

An intrinsic light that emits light outwards from
a sphere. This light is one-sided, so no light is emitted "inside" the sphere.
This light can be used as a zero-radius "point light" if `treatAsPoint` is 
true, and the renderer being used supports zero-area lights.

Use SphereLights to simulate point and spherical shaped light sources, like 
light bulbs and headlamps. 

The following simple example has a SphereLight positioned near a Sphere and 
Cube, with a radius of 0.8.

```{code-block} usda
#usda 1.0
(
    upAxis = "Y"
)

def Scope "Lights"
{
    def SphereLight "Light1"
    {
        float inputs:radius = 0.8

        color3f inputs:color = (1, 1, 1)
        float inputs:intensity = 20.0
        double3 xformOp:translate = (4, 0, 1)
        uniform token[] xformOpOrder = ["xformOp:translate"]
    }
}

def Xform "TestGeom"
{
    def Sphere "Sphere1"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double3 xformOp:translate = (0, 0, -2)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }

    def Cube "Cube"
    {
        token purpose = "render"
        color3f[] primvars:displayColor = [(1, 1, 1)] (
            interpolation = "constant"
        )    
        double size = 8
        double3 xformOp:translate = (0, 0, -8)
        uniform token[] xformOpOrder = ["xformOp:translate"]          
    }
}
```

Example RenderMan output for this layer (compare with the output for the
{ref}`DiskLight` example, which has a similar configuration):

```{image} lux_sphere_light.png
:alt: Example SphereLight
:width: 600px
```


```{contents}
:depth: 2
:local:
:backlinks: none
```

(SphereLight_properties)=

## Properties

(SphereLight_inputs:radius)=

### inputs:radius

**USD type**: `float`

**Fallback value**: `0.5`

Radius of the sphere.


(SphereLight_light:shaderId)=

### light:shaderId

**USD type**: `token`

**Fallback value**: `SphereLight`

The shader ID for a SphereLight. 
USD will also register a Sdr shader node with a "SphereLight" identifier and 
the source type "USD" to correspond to the light's inputs


(SphereLight_treatAsPoint)=

### treatAsPoint

**USD type**: `bool`

**Fallback value**: `False`

This is used as a hint to renderers that this
light can be treated as a "point light", effectively a zero-radius sphere.
This is useful for renderers that support non-area lighting. Renderers that
only support area lights will ignore this attribute.


(SphereLight_inheritedproperties_Boundable)=

## Inherited Properties ({ref}`Boundable`)

(SphereLight_extent)=

### extent

**USD type**: `float3[]`



(SphereLight_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(SphereLight_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(SphereLight_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(SphereLight_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(SphereLight_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(SphereLight_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


