% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 08:58AM on April 22, 2025


(SpatialAudio)=
# SpatialAudio

Defines the properties that enable audio playback 
in the scene.
        
SpatialAudio specifies which audio should play (`filePath`), the mode in which 
the audio is played (`auralMode`), and the playback settings (combinations of 
`startTime`, `endTime`, `playbackMode`, and `mediaOffset`).

The example below shows a typical use case, featuring `Speech` and `Ambient` 
prims. We can infer from the example the following information:
- `Speech` spatially plays from the location of the Cube in the scene, whereas 
`Ambient` is non-spatial and sounds the same regardless of the listener's 
position.
- `Speech` is nested under the `Cube` gprim, in case the gprim is ever moved or 
animated.
- `Speech` plays for 10 seconds, based on: 
`endTime` (480) - `startTime` (240) / `timeCodesPerSecond` (24) = 10.
- The audio from the `mySpeech.mp3` plays from the 10th second of the audio 
file (`startTime` (240) / `timeCodesPerSecond` (24)) to the 20th second of the 
audio file (`endTime` (480) / `timeCodesPerSecond` (24)).
- `Speech` does not loop based on `playbackMode = onceFromStartToEnd`.
- `Ambient` loops based on `playbackMode = loopFromStage`.
- `Ambient` plays for all 100 seconds of the scene.

```{code-block} usda
#usda 1.0
(
    defaultPrim = "World"
    endTimeCode = 2400
    startTimeCode = 0
    timeCodesPerSecond = 24
)

def Xform "World"
{
    def Cube "Cube"
    {
        double3 xformOp:translate = (1, 5, -2)
        uniform token[] xformOpOrder = ["xformOp:translate"]

        def SpatialAudio "Speech"
        {
            uniform token auralMode = "spatial"
            uniform timecode endTime = 480
            uniform asset filePath = @mySpeech.mp3@
            uniform token playbackMode = "onceFromStartToEnd"
            uniform timecode startTime = 240
        }
    }

    def SpatialAudio "Ambient"
    {
        uniform token auralMode = "nonSpatial"
        uniform asset filePath = @myAmbientTrack.mp3@
        uniform token playbackMode = "loopFromStage"
    }
}
```

## SpatialAudio and Layer Offsets 

If a layer has a {ref}`layer offset <usdglossary-layeroffset>`, the 
layer offset information is applied to "timecode" valued attributes 
during value resolution. As `startTime` and `endTime` are "timecode" valued 
attributes, this means SpatialAudio playback is adjusted by layer offset,
and can be kept "in sync" with time sampled animation in the layer. Note that
if the layer offset includes a time *scale*, USD does not attempt to apply any
playback dilation of the actual audio media.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(SpatialAudio_properties)=

## Properties

(SpatialAudio_auralMode)=

### auralMode

**USD type**: `token`

**Fallback value**: `spatial`

How the audio is played, spatially or not.

Valid values are: 
 - `spatial`: Audio is playing from the source of the prim or parent prim. 
 For example this could be used for a character so the audio from the 
 character always comes from their location.
 - `nonSpatial`: Does not consider the prim's location, intended to be used 
 for ambient sounds.
 

(SpatialAudio_endTime)=

### endTime

**USD type**: `timecode`

**Fallback value**: `0`

Offset from the start of the audio file for 
when to end playing, in timeCodes.

Given a 10 second audio file, with a stage `timeCodesPerSecond` value of 24, 
and an `endTime` value of 48.0, audio will end playing 2 seconds into the 
audio file.

(SpatialAudio_filePath)=

### filePath

**USD type**: `asset`

**Fallback value**: `@@`

Path to the audio file.

Expected file formats: m4a, mp3, wav
            

(SpatialAudio_gain)=

### gain

**USD type**: `double`

**Fallback value**: `1.0`

Multiplier to the given audio signal.

A value of 0 is expected to mute the audio.


(SpatialAudio_mediaOffset)=

### mediaOffset

**USD type**: `double`

**Fallback value**: `0.0`

Amount, in seconds, the audio is offset when 
playing.

Given a 10 second audio file, and a `mediaOffset` of 3.0, audio will not play 
for the first 3 seconds, then will start playing at the beginning of the audio 
file.
For looping audio files, this offset is only applied for the first loop.


(SpatialAudio_playbackMode)=

### playbackMode

**USD type**: `token`

**Fallback value**: `onceFromStart`

Determines general rules on the playback 
of the audio asset. Use this to specify when the audio should start, stop, 
and if the playback should loop.

See the table below for how available values relate to whether the audio 
loops and when the audio starts / stops.
| Value                 | Audio Loops?  | StartTime                     | EndTime                                       |
| --------              | -------       | -------                       | -------                                       |
| `onceFromStart`       | no            | `startTime` of the prim       | end of audio file                             |
| `onceFromStartToEnd`  | no            | `startTime` of the prim       | `endTime` of the prim, or end of audio file   |
| `loopFromStart`       | yes           | `startTime` of the prim       | `endTimeCode` of the stage                    |
| `loopFromStartToEnd`  | yes           | `startTime` of the prim       | `endTime` of the prim                         |
| `loopFromStage`       | yes           | `startTimeCode` of the stage  | `endTimeCode` of the stage                    |



(SpatialAudio_startTime)=

### startTime

**USD type**: `timecode`

**Fallback value**: `0`

Offset from the start of the audio file for 
when to start playing, in timeCodes.

Given a 10 second audio file, with a stage `timeCodesPerSecond` value of 24, 
and a `startTime` value of 24.0, audio will start playing 1 second into the 
audio file.

(SpatialAudio_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(SpatialAudio_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(SpatialAudio_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(SpatialAudio_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(SpatialAudio_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(SpatialAudio_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


