% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 02:21PM on June 30, 2025


(RenderPass)=
# RenderPass

A RenderPass represents the renderer and scene 
configuration for a single render pass in a multi-pass rendering workflow. 
For example, you might have a workflow that uses separate render passes to 
render the foreground and background portions of a scene, and a third pass that 
composites the foreground and background render output into the final frame. 

A RenderPass lets you:

- Specify renderer configuration for the render pass. This can be either a 
relationship to a {ref}`RenderSettings` prim, or a file specifying render
configuration, e.g. Houdini passes might point to a Rop, Nuke passes would point 
to a write node.
- Specify scene configuration for the render pass by setting a USD 
{ref}`collection <collections_and_patterns>` that describes the prims that will 
be visible to the renderer. 
- Specify any renderer-specific configuration for the render pass that isn't 
covered by {ref}`RenderSettings`, including custom render commands. 
- Define the dependencies *between* render passes, which is used by renderers 
to describe the workflow for a sequence of render passes. In the 
foreground/background example given previously, the "composite" pass has a 
dependency on the foreground/background passes, as it needs the render output 
from the foreground/background passes as input to the composite render pass.

The following example shows three RenderPasses. A "foreground" pass and a 
"background" pass are specified that use RenderMan and the "PrimarySettings" 
RenderSettings configuration, but specify different parts of the stage to render 
using the RenderPass renderVisibility collection. A final "composite" 
pass is also specified that uses Nuke and takes the results from the other two 
passes as inputPasses. Note that the nuke:writeNode attribute 
and Nuke renderSource are hypothetical examples that would be associated 
with a Nuke-supplied API schema applied to the "composite" RenderPass prim -- 
USD does not provide any default Nuke render configuration support. 

```{code-block} usda
def Scope "Render"
{
    ...settings and products...

    def Scope "Passes"
    {
        def RenderPass "foreground" 
        {
            token passType = "prman"
            rel renderSource = <Render/PrimarySettings>
            string[] command = ["prman"]
            uniform bool collection:renderVisibility:includeRoot = false
            prepend rel collection:renderVisibility:includes = [
                </World/characters>,
                </World/sets/Kitchen/Table_grp>,
            ]
        }
        def RenderPass "background" 
        {
            token passType = "prman"
            rel renderSource = <Render/PrimarySettings>
            string[] command = ["prman"]
            uniform bool collection:renderVisibility:includeRoot = true
            prepend rel collection:renderVisibility:excludes = [
                </World/characters>,
                </World/sets/Kitchen/Table_grp>,
            ]
        }
        def RenderPass "composite"
        {
            token passType = "nuke"
            asset fileName = @composite.nk@
            # this nuke-namespaced property might come from a hypothetical Nuke-supplied API schema
            string nuke:writeNode = "WriteFinalComposite"
            rel renderSource = </Render/Passes/composite.nuke:writeNode>
           string[] command = ["nuke", "-x", "-c", "32G"]
            rel inputPasses = [
                </Render/Passes/foreground>,
                </Render/Passes/background>
            ]
        }
    }
}
```

RenderPasses are typically consumed by runtime executables that generate 
images based on information from the RenderPass prim. Additionally, RenderPasses
are consumed by render pipeline code that translates between RenderPass 
information and the pipeline's render job/task scheduling software. Typically 
the name of the RenderPass prim is used as the pass's name in pipeline tools.

RenderPass also lets you use 
{ref}`collections of prims <collections_and_patterns>` to control prim 
visibility or behavior for the given pass. These collections are:

- renderVisibility: This collection describes which prims are visible to the 
renderer for this pass. 
- cameraVisibility: This collection describes
which prims are visible to the main camera for this pass, with the camera
specified in the pass's renderSource. 
- prune: This collection describes which prims are *removed* from the scene 
prior to rendering this pass.
- matte: This collection describes which prims should act as 'matte objects' 
during this render pass. Matte objects render with zero alpha.

See {ref}`usdRender_using_renderpass_collections` for more details on these 
collections.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(RenderPass_properties)=

## Properties

(RenderPass_collection:cameraVisibility:includeRoot)=

### collection:cameraVisibility:includeRoot

**USD type**: `bool`

**Fallback value**: `True`

This property is instantiated in the schema 
to override the fallback value from the CollectionAPI to true.

(RenderPass_collection:renderVisibility:includeRoot)=

### collection:renderVisibility:includeRoot

**USD type**: `bool`

**Fallback value**: `True`

This property is instantiated in the schema 
to override the fallback value from the CollectionAPI to true.

(RenderPass_command)=

### command

**USD type**: `string[]`

The command to run in order to generate
renders for this pass. Used by render pipelines to send jobs to scheduling
components that will generate renders. 

The strings in the command array can be used to specify a process and its 
arguments. The strings also can contain variables, contained in {} braces,
that will be substituted when the command is submitted. The following example
command runs the RenderMan `prman` command with a set of arguments and a
variable argument that will be substituted with the `fileName` value.

```{code-block} usda
def RenderPass "PrimaryRenderManPass"
{
    token passType = "prman"
    asset fileName = @extraConfig.arg@
    rel renderSource = </Render/PrimarySettings>
    string[] command = ["prman", "-progress", "-pixelvariance", "-0.15", "{fileName}"]
}
```


(RenderPass_fileName)=

### fileName

**USD type**: `asset`

The asset that contains the render configuration
prims or other information needed to render this pass. Used by 
{ref}`RenderPass_renderSource`.

(RenderPass_inputPasses)=

### inputPasses

**USD type**: `rel` (relationship)

The set of other RenderPasses that this pass 
depends on in order to be constructed properly. For example, 'Pass A' might
generate a texture, which is then used as input to 'Pass B', so 'Pass B' would
specify the 'Pass A' RenderPass prim as a relationship target for inputPasses.
 
USD provides this dependency information for render harnesses to use in 
properly computing dependency passes, and assumes that the harnesses will 
traverse and account for the transitive dependencies. 

USD additionally makes the following assumption about per-frame tasks:
        
When per-frame tasks are generated from RenderPass prims that have inputPasses
dependencies, USD will assume a one-to-one relationship between tasks
that share the same frame number. Consider a pass named 'composite'
whose `inputPasses` targets a RenderPass prim named 'beauty'.  
By default, each frame for 'composite' will depend on the same frame from 
'beauty':

beauty.1 -> composite.1
beauty.2 -> composite.2
etc.

The consumer of the RenderPass dependency graph of inputs will need to resolve
any transitive dependencies.


(RenderPass_passType)=

### passType

**USD type**: `token`

A string used to categorize differently 
structured or executed types of passes within a customized render pipeline.

For example, when multiple DCC's (e.g. Houdini, Katana, Nuke) each compute and 
contribute different Products to a final result, it may be clearest and most 
flexible to create a separate RenderPass for each.


(RenderPass_renderSource)=

### renderSource

**USD type**: `rel` (relationship)

The source for render configuration for this
pass. If {ref}`RenderPass_fileName` is not authored, the source is assumed to 
be a {ref}`RenderSettings` prim present in the current stage. If fileName is 
present, the source should be found in that file. In this case, the 
`renderSource` relationship might target a string attribute on this or another 
prim that identifies the appropriate object in the external container.
