% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 02:21PM on June 30, 2025


(RenderProduct)=
# RenderProduct

Represents a single render output artifact, such as 
a rendered image file, output depth buffer, or other file-like artifact. A
RenderProduct combines one or more {ref}`RenderVars <RenderVar>` into the 
output artifact. 

```{code-block} usda
def RenderProduct "PrimaryProduct" {
    token productName = "/output/render000009.png"
    rel orderedVars = [
        </Render/Vars/color>,
        </Render/Vars/alpha>,
        </Render/Vars/directDiffuse>
    ]
}
```

RenderProduct also provides many of the same configuration attributes present
in {ref}`RenderSettings`, which allows for configuration overrides per product.
Additionally, RenderProduct provides product-specific attributes, such as 
`productName`, which for a rendered image artifact is used for the image 
filename.

```{code-block} usda
def RenderProduct "PrimaryProduct" {

    # --- product-specific ---
    uniform token productType = "deepRaster"
    uniform token productName = "/output/render000009.png"

    # --- overrides ---

    # For this product, override our RenderSettings camera and resolution 
    rel camera = </Cameras/stereo_cam>
    uniform int2 resolution = (3840, 2160)

    # ...other settings...
}
```

Renderers may also support additional renderer-specific configuration, such as 
compression settings, filetype metadata, and more. Such settings can be 
encoded using renderer-specific API schemas applied to the RenderProduct prim.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(RenderProduct_properties)=

## Properties

(RenderProduct_orderedVars)=

### orderedVars

**USD type**: `rel` (relationship)

The set of relationships to 
{ref}`RenderVars <RenderVar>` that are used and combined into the final output
product. The order of the relationship targets is passed to the output tools in 
case the order is needed to produce the artifact properly.


(RenderProduct_productName)=

### productName

**USD type**: `token`

**Fallback value**: ``

The name for the output product. 
The value is provided as-is to render executables and pipeline tools, which in 
turn are responsible for using the value as needed, e.g. using the productName 
for the filename (and path) for an output image artifact.


(RenderProduct_productType)=

### productType

**USD type**: `token`

**Fallback value**: `raster`

The type of output to produce. USD provides
common output types that most renderers should be able to produce:

- "raster": This is the default type and indicates a 2D raster image of
pixels.
- "deepRaster": Indicates a deep image that contains multiple samples
per pixel at varying depths.            

Renderers can also support custom output types by providing an API schema that 
adds additional productType tokens. For example, the following snippet uses
a (mocked) renderer-specific applied API schema that adds the 
"newRenderer:productType" attribute that this specific renderer will use in 
place of productType.

```{code-block} usda
def RenderProduct "NewRendererProduct" 
(
    apiSchemas = ["NewRendererAPI"]
)
{
    # For this product, apply renderer-specific productType
    uniform token newRenderer:productType = "rasterNoBackground"
    
    #...opinions for remaining RenderProduct attributes as needed...
}
```        


(RenderProduct_inheritedproperties_RenderSettingsBase)=

## Inherited Properties ({ref}`RenderSettingsBase`)

(RenderProduct_aspectRatioConformPolicy)=

### aspectRatioConformPolicy

**USD type**: `token`

**Fallback value**: `expandAperture`

The policy used to resolve an aspect ratio 
mismatch between the camera aperture and image aspect ratio. Because the camera 
aperture and image dimensions are specified independently, mismatches between
aspect ratios can occur. For example, an interactive viewport may be resized to 
a ratio that does not match the camera, or a pipeline may be configured with a 
standard resolution that may not match a particular camera.

The camera aperture aspect ratio is determined by the aperture attributes on 
{ref}`Camera`. The image aspect ratio is determined by the 
{ref}`resolution <RenderSettingsBase_resolution>` and
{ref}`pixelAspectRatio <RenderSettingsBase_pixelAspectRatio>` attributes.

The policy values and how they resolve mismatches are as follows:

- "expandAperture": if necessary, expand the aperture to fit the image, 
exposing additional scene content. This is the fallback value.
- "cropAperture": if necessary, crop the aperture to fit the image, cropping 
scene content.
- "adjustApertureWidth": if necessary, adjust aperture width to make its aspect 
ratio match the image.
- "adjustApertureHeight": if necessary, adjust aperture height to make its 
aspect ratio match the image.
- "adjustPixelAspectRatio": compute pixelAspectRatio to make the image 
exactly cover the aperture. This disregards any existing authored 
pixelAspectRatio value.


(RenderProduct_camera)=

### camera

**USD type**: `rel` (relationship)

This relationship specifies the primary camera
to use for a render. The relationship must target a {ref}`Camera`. The targeted 
camera prim determines the visual composition of the scene as an image.

See {ref}`render_camera` for more details on Camera prims used for renders.


(RenderProduct_dataWindowNDC)=

### dataWindowNDC

**USD type**: `float4`

**Fallback value**: `(0, 0, 1, 1)`

The axis-aligned rectangular region in the 
adjusted aperture window within which the renderer should produce data.
Specified as (xmin, ymin, xmax, ymax) in normalized device coordinates (NDC), 
where the range 0 to 1 corresponds to the aperture.

Specifying a window outside the unit square will produce overscan data. 
Specifying a window that does not cover the unit square will produce a cropped 
render.

A pixel is included in the rendered result if the pixel center is contained by 
the data window. This is consistent with standard rules used by polygon 
rasterization engines.

The data window is expressed in normalized device coordinates so that cropping 
and overscan may be resolution independent. In interactive workflows, 
incremental cropping and resolution adjustment may be intermixed to isolate and 
examine parts of the scene. In compositing workflows, overscan may be used to 
support image post-processing kernels, and reduced-resolution proxy renders may 
be used for faster iteration.


(RenderProduct_disableDepthOfField)=

### disableDepthOfField

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all depth of field by setting 
F-stop of the targeted camera to infinity.

(RenderProduct_disableMotionBlur)=

### disableMotionBlur

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all motion blur by setting the 
shutter interval of the render camera to [0,0]. This will ensure the render
only takes one sample at the current time code.

The following example disables motion blur.

```{code-block} usda
def RenderSettings "NoBlurRenderSettings"
{
    uniform bool disableMotionBlur = 1
    ...
}
```


(RenderProduct_instantaneousShutter)=

### instantaneousShutter

**USD type**: `bool`

**Fallback value**: `False`

Deprecated, use disableMotionBlur instead.

(RenderProduct_pixelAspectRatio)=

### pixelAspectRatio

**USD type**: `float`

**Fallback value**: `1.0`

The aspect ratio (width/height) of the 
rendered image pixels. The default value of 1.0 specifies square pixels, but
non-square pixels are also supported. The 
{ref}`resolution <RenderSettingsBase_resolution>` and pixel aspect ratio 
together determine the total aspect ratio of the rendered image.

Note that because the camera aperture and image dimensions are specified
independently, there may be a mismatch in overall aspect ratios. Use the
{ref}`aspectRatioConformPolicy <RenderSettingsBase_aspectRatioConformPolicy>` 
attribute to communicate to the renderer how to resolve the mismatch.


(RenderProduct_resolution)=

### resolution

**USD type**: `int2`

**Fallback value**: `(2048, 1080)`

The image resolution in pixels. The 
{ref}`render camera's <RenderSettingsBase_camera>` screen window (projection
of the camera aperture bounds to screen coordinates) is sampled by the 
renderer to a raster image of this resolution.

The resolution and {ref}`pixel aspect ratio <RenderSettingsBase_pixelAspectRatio>`
together determine the total aspect ratio of the rendered image.

