% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 02:21PM on June 30, 2025


(RenderSettings)=
# RenderSettings

Encapsulates all the global settings that 
tell a renderer what render settings to use, and what render output to produce, 
for a single invocation of rendering the scene. 

Note that renderers are expected to apply or auto-apply API schemas to 
RenderSettings that codify any renderer-specific global configuration, such 
as Renderer options for RenderMan.

RenderSettings provides the
following attributes (in addition to attributes inherited from 
{ref}`RenderSettingsBase`):

- `products`: Relationship targets for one or more 
{ref}`RenderProducts <RenderProduct>` that specify what render artifacts should 
be produced by the renderer. If no products are provided, renderers should 
render a default RGB image. If products are provided, the products should be 
explicit about which {ref}`RenderVars <RenderVar>` are needed.
- `includedPurposes`: The {ref}`imageable purposes <render_purpose>` to be 
rendered. Imageable prims with this renderPurpose set will be rendered. Note 
that prims that have no authored or inherited purpose (i.e. the prim has the 
fallback "default" purpose) are always rendered. See 
{ref}`usdRender_using_imageable_purpose` for an example.
- `materialBindingPurposes`: The 
{ref}`material binding purposes <material_binding_purpose>` to be rendered. 
Gprims with material binding purpose set to a purpose in this list will be
rendered using that binding purpose. See 
{ref}`usdRender_using_materialbindingpurposes` for an example.
- `renderingColorSpace`: The renderer *working* color space. This is the 
(linear) color space a renderer should use to do internal calculations for the 
given render invocation. If this is not set, a renderer is expected to use 
whatever default color space it normally uses. Regardless of what this is set 
to (or not set), the renderer may still need to convert scene-referred color 
spaces on scene content into its working color space.

The following simple example RenderSettings prim includes opinions for 
properties from RenderSettings as well as inherited properties from 
RenderSettingsBase.

```{code-block} usda
def RenderSettings "RenderSettings" {

    # Properties inherited from RenderSettingsBase 
    rel camera = </Cameras/main_cam>
    uniform int2 resolution = (1024, 1024) 
    uniform float pixelAspectRatio = 1.0 
    uniform token aspectRatioConformPolicy = "adjustApertureHeight" 
    uniform float4 dataWindowNDC = (0,0,1,1)
    uniform bool disableMotionBlur = false
    uniform bool disableDepthOfField = false

    # RenderSettings properties 
    rel products = </Render/PrimaryProduct>
    uniform token[] includedPurposes = ["render", "default"]
    uniform token[] materialBindingPurposes = ["full"]
    uniform token renderingColorSpace = "srgb_rec709_scene"
}
```

```{contents}
:depth: 2
:local:
:backlinks: none
```

(RenderSettings_properties)=

## Properties

(RenderSettings_includedPurposes)=

### includedPurposes

**USD type**: `token[]`

**Fallback value**: `[ "default", "render" ]`

The list of 
{ref}`imageable purpose <render_purpose>` values that should be included in the
render. Imageable prims with purpose set to one of the includedPurposes 
values will be rendered. Note that prims that have no authored or inherited 
purpose (i.e. the prim has the fallback "default" purpose) are always rendered.

The following example RenderSettings prim has includedPurposes set to
`["proxy", "default"]`, so only prims with purpose set to "proxy" or prims 
with no authored/inherited purpose will be rendered.

```{code-block} usda
def RenderSettings "ViewportSettings" {
    uniform token[] includedPurposes = ["proxy", "default"]
}
```


(RenderSettings_materialBindingPurposes)=

### materialBindingPurposes

**USD type**: `token[]`

**Fallback value**: `[ "full", "" ]`

The ordered list of material binding purposes
used in the render. 

This is used to control which material binding purpose to use if a prim has 
multiple binding purposes. For example, if we use a RenderSettings with 
materialBindingPurposes set to ["full"]:

```{code-block} usda
def RenderSettings "PrimarySettings" {
    uniform token[] materialBindingPurposes = ["full"]
}
```

The renderer will look for and use `material:binding:full` material 
bindings, and if not found, use the "all purpose" `material:binding`
material binding if present.

See {ref}`material_binding_purpose` for more information on material binding
purposes with imageable Gprims, and 
{ref}`usdRender_using_materialbindingpurposes` for more information on setting 
materialBindingPurposes.


(RenderSettings_products)=

### products

**USD type**: `rel` (relationship)

The set of relationships to 
{ref}`RenderProducts <RenderProduct>` that rendering this scene should 
produce. If no products are specified, renderers are expected to produce a 
default RGB image. If products are provided, the products should be 
explicit about which {ref}`RenderVars <RenderVar>` are needed.

(RenderSettings_renderingColorSpace)=

### renderingColorSpace

**USD type**: `token`

Specifies the rendering color space, sometimes
referred to as the "working" color space. This is the (linear) color space a 
renderer should use to do internal calculations for the given render
invocation. If this is not set, a renderer is expected to use whatever default
color space it normally uses.

Note that this color space should not be confused with specific color spaces for 
scene objects. If you need to specify particular color spaces for objects
(say, a texture asset that was created with a particular color space), or 
transform between color spaces, you should use the ColorSpaceAPI and
ColorSpaceDefinitionAPI schemas on prims that need to specify color
space information. USD has specific rules on how color spaces specified on 
objects are propagated and resolved. These rules are applied by a combination 
of the Hydra rendering framework and the renderer's own texture readers.

See {ref}`color_users_guide` for more details on working with color spaces with
USD objects.


(RenderSettings_inheritedproperties_RenderSettingsBase)=

## Inherited Properties ({ref}`RenderSettingsBase`)

(RenderSettings_aspectRatioConformPolicy)=

### aspectRatioConformPolicy

**USD type**: `token`

**Fallback value**: `expandAperture`

The policy used to resolve an aspect ratio 
mismatch between the camera aperture and image aspect ratio. Because the camera 
aperture and image dimensions are specified independently, mismatches between
aspect ratios can occur. For example, an interactive viewport may be resized to 
a ratio that does not match the camera, or a pipeline may be configured with a 
standard resolution that may not match a particular camera.

The camera aperture aspect ratio is determined by the aperture attributes on 
{ref}`Camera`. The image aspect ratio is determined by the 
{ref}`resolution <RenderSettingsBase_resolution>` and
{ref}`pixelAspectRatio <RenderSettingsBase_pixelAspectRatio>` attributes.

The policy values and how they resolve mismatches are as follows:

- "expandAperture": if necessary, expand the aperture to fit the image, 
exposing additional scene content. This is the fallback value.
- "cropAperture": if necessary, crop the aperture to fit the image, cropping 
scene content.
- "adjustApertureWidth": if necessary, adjust aperture width to make its aspect 
ratio match the image.
- "adjustApertureHeight": if necessary, adjust aperture height to make its 
aspect ratio match the image.
- "adjustPixelAspectRatio": compute pixelAspectRatio to make the image 
exactly cover the aperture. This disregards any existing authored 
pixelAspectRatio value.


(RenderSettings_camera)=

### camera

**USD type**: `rel` (relationship)

This relationship specifies the primary camera
to use for a render. The relationship must target a {ref}`Camera`. The targeted 
camera prim determines the visual composition of the scene as an image.

See {ref}`render_camera` for more details on Camera prims used for renders.


(RenderSettings_dataWindowNDC)=

### dataWindowNDC

**USD type**: `float4`

**Fallback value**: `(0, 0, 1, 1)`

The axis-aligned rectangular region in the 
adjusted aperture window within which the renderer should produce data.
Specified as (xmin, ymin, xmax, ymax) in normalized device coordinates (NDC), 
where the range 0 to 1 corresponds to the aperture.

Specifying a window outside the unit square will produce overscan data. 
Specifying a window that does not cover the unit square will produce a cropped 
render.

A pixel is included in the rendered result if the pixel center is contained by 
the data window. This is consistent with standard rules used by polygon 
rasterization engines.

The data window is expressed in normalized device coordinates so that cropping 
and overscan may be resolution independent. In interactive workflows, 
incremental cropping and resolution adjustment may be intermixed to isolate and 
examine parts of the scene. In compositing workflows, overscan may be used to 
support image post-processing kernels, and reduced-resolution proxy renders may 
be used for faster iteration.


(RenderSettings_disableDepthOfField)=

### disableDepthOfField

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all depth of field by setting 
F-stop of the targeted camera to infinity.

(RenderSettings_disableMotionBlur)=

### disableMotionBlur

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all motion blur by setting the 
shutter interval of the render camera to [0,0]. This will ensure the render
only takes one sample at the current time code.

The following example disables motion blur.

```{code-block} usda
def RenderSettings "NoBlurRenderSettings"
{
    uniform bool disableMotionBlur = 1
    ...
}
```


(RenderSettings_instantaneousShutter)=

### instantaneousShutter

**USD type**: `bool`

**Fallback value**: `False`

Deprecated, use disableMotionBlur instead.

(RenderSettings_pixelAspectRatio)=

### pixelAspectRatio

**USD type**: `float`

**Fallback value**: `1.0`

The aspect ratio (width/height) of the 
rendered image pixels. The default value of 1.0 specifies square pixels, but
non-square pixels are also supported. The 
{ref}`resolution <RenderSettingsBase_resolution>` and pixel aspect ratio 
together determine the total aspect ratio of the rendered image.

Note that because the camera aperture and image dimensions are specified
independently, there may be a mismatch in overall aspect ratios. Use the
{ref}`aspectRatioConformPolicy <RenderSettingsBase_aspectRatioConformPolicy>` 
attribute to communicate to the renderer how to resolve the mismatch.


(RenderSettings_resolution)=

### resolution

**USD type**: `int2`

**Fallback value**: `(2048, 1080)`

The image resolution in pixels. The 
{ref}`render camera's <RenderSettingsBase_camera>` screen window (projection
of the camera aperture bounds to screen coordinates) is sampled by the 
renderer to a raster image of this resolution.

The resolution and {ref}`pixel aspect ratio <RenderSettingsBase_pixelAspectRatio>`
together determine the total aspect ratio of the rendered image.

