% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 02:21PM on June 30, 2025


(RenderSettingsBase)=
# RenderSettingsBase

Abstract base class that defines render 
settings that can be specified on either a RenderSettings prim or a 
RenderProduct prim.
```{contents}
:depth: 2
:local:
:backlinks: none
```

(RenderSettingsBase_properties)=

## Properties

(RenderSettingsBase_aspectRatioConformPolicy)=

### aspectRatioConformPolicy

**USD type**: `token`

**Fallback value**: `expandAperture`

The policy used to resolve an aspect ratio 
mismatch between the camera aperture and image aspect ratio. Because the camera 
aperture and image dimensions are specified independently, mismatches between
aspect ratios can occur. For example, an interactive viewport may be resized to 
a ratio that does not match the camera, or a pipeline may be configured with a 
standard resolution that may not match a particular camera.

The camera aperture aspect ratio is determined by the aperture attributes on 
{ref}`Camera`. The image aspect ratio is determined by the 
{ref}`resolution <RenderSettingsBase_resolution>` and
{ref}`pixelAspectRatio <RenderSettingsBase_pixelAspectRatio>` attributes.

The policy values and how they resolve mismatches are as follows:

- "expandAperture": if necessary, expand the aperture to fit the image, 
exposing additional scene content. This is the fallback value.
- "cropAperture": if necessary, crop the aperture to fit the image, cropping 
scene content.
- "adjustApertureWidth": if necessary, adjust aperture width to make its aspect 
ratio match the image.
- "adjustApertureHeight": if necessary, adjust aperture height to make its 
aspect ratio match the image.
- "adjustPixelAspectRatio": compute pixelAspectRatio to make the image 
exactly cover the aperture. This disregards any existing authored 
pixelAspectRatio value.


(RenderSettingsBase_camera)=

### camera

**USD type**: `rel` (relationship)

This relationship specifies the primary camera
to use for a render. The relationship must target a {ref}`Camera`. The targeted 
camera prim determines the visual composition of the scene as an image.

See {ref}`render_camera` for more details on Camera prims used for renders.


(RenderSettingsBase_dataWindowNDC)=

### dataWindowNDC

**USD type**: `float4`

**Fallback value**: `(0, 0, 1, 1)`

The axis-aligned rectangular region in the 
adjusted aperture window within which the renderer should produce data.
Specified as (xmin, ymin, xmax, ymax) in normalized device coordinates (NDC), 
where the range 0 to 1 corresponds to the aperture.

Specifying a window outside the unit square will produce overscan data. 
Specifying a window that does not cover the unit square will produce a cropped 
render.

A pixel is included in the rendered result if the pixel center is contained by 
the data window. This is consistent with standard rules used by polygon 
rasterization engines.

The data window is expressed in normalized device coordinates so that cropping 
and overscan may be resolution independent. In interactive workflows, 
incremental cropping and resolution adjustment may be intermixed to isolate and 
examine parts of the scene. In compositing workflows, overscan may be used to 
support image post-processing kernels, and reduced-resolution proxy renders may 
be used for faster iteration.


(RenderSettingsBase_disableDepthOfField)=

### disableDepthOfField

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all depth of field by setting 
F-stop of the targeted camera to infinity.

(RenderSettingsBase_disableMotionBlur)=

### disableMotionBlur

**USD type**: `bool`

**Fallback value**: `False`

Use to disable all motion blur by setting the 
shutter interval of the render camera to [0,0]. This will ensure the render
only takes one sample at the current time code.

The following example disables motion blur.

```{code-block} usda
def RenderSettings "NoBlurRenderSettings"
{
    uniform bool disableMotionBlur = 1
    ...
}
```


(RenderSettingsBase_instantaneousShutter)=

### instantaneousShutter

**USD type**: `bool`

**Fallback value**: `False`

Deprecated, use disableMotionBlur instead.

(RenderSettingsBase_pixelAspectRatio)=

### pixelAspectRatio

**USD type**: `float`

**Fallback value**: `1.0`

The aspect ratio (width/height) of the 
rendered image pixels. The default value of 1.0 specifies square pixels, but
non-square pixels are also supported. The 
{ref}`resolution <RenderSettingsBase_resolution>` and pixel aspect ratio 
together determine the total aspect ratio of the rendered image.

Note that because the camera aperture and image dimensions are specified
independently, there may be a mismatch in overall aspect ratios. Use the
{ref}`aspectRatioConformPolicy <RenderSettingsBase_aspectRatioConformPolicy>` 
attribute to communicate to the renderer how to resolve the mismatch.


(RenderSettingsBase_resolution)=

### resolution

**USD type**: `int2`

**Fallback value**: `(2048, 1080)`

The image resolution in pixels. The 
{ref}`render camera's <RenderSettingsBase_camera>` screen window (projection
of the camera aperture bounds to screen coordinates) is sampled by the 
renderer to a raster image of this resolution.

The resolution and {ref}`pixel aspect ratio <RenderSettingsBase_pixelAspectRatio>`
together determine the total aspect ratio of the rendered image.

