% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 05:23PM on April 01, 2025


(AccessibilityAPI)=
# AccessibilityAPI

This schema describes accessibility information on 
a Prim that may be surfaced to a given runtime's accessibility frameworks. This 
information may be used by assistive tooling such as voice controls or screen 
readers.

Accessibility information is provided as a standard triplet of label, 
description, and priority. 

```{code-block} usda
def Mesh "Cube" (
    prepend apiSchemas = ["AccessibilityAPI"]
) {
    string accessibility:default:label = "Luxo, Jr"
    string accessibility:default:description = "The lamp has round base with two sections above it that may be adjusted. It has a conical head with a lightbulb inside. It likes to chase inflatable balls"
    token accessibility:default:priority = "standard"
}
```

This is a multiple apply schema, and so may have multiple namespaced 
accessibility triplets, where a instance name may reflect a given purpose for 
that triplet. For example, you may desire to express different information for 
different aspects of the prim, such as size or color. Note that this schema will 
use "default" as an instance name if no namespace is specified.

There are several best practices for using this schema.:

- Most accessibility runtimes support a single accessibility description.
Therefore we recommend placing any critical information in the default
instance.

- A default value should be authored if using time sampled accessibility
information. This helps accessibility runtimes that do not currently
support time sampled information.

- Provide accessibility information of your scene on the default prim
of the layer, and any root level prims. This allows accessibility systems to
provide concise scene descriptions to a user, but also allows supporting
accessibility systems that either do not support hierarchy information or
when a user has turned off that level of granularity. Accessibility
information may still be provided on other prims in the hierarchy.

The use of the default prim and root level prims for scene accessibility 
descriptions is a recommended convention. Outside of that, accessibility 
information is not implicitly inherited through a prim hierarchy. 

```{contents}
:depth: 2
:local:
:backlinks: none
```

(AccessibilityAPI_properties)=

## Properties

(AccessibilityAPI_description)=

### description

**USD type**: `string`

An extended description of the prim to provide 
more details. If a label attribute is not authored in a given instance name,
the description attribute should not be used in it its place. A description is 
an optional attribute, and some accessibility systems may only use the label.

Descriptions may be time varying for runtimes that support it. For example, you 
may describe what a character is doing at a given time.


(AccessibilityAPI_label)=

### label

**USD type**: `string`

A short label to concisely describe the prim.
It is not recommended to time vary the label unless the concise description 
changes substantially.

There is no specific suggested length for the label, but it is recommended to 
keep it succinct.


(AccessibilityAPI_priority)=

### priority

**USD type**: `token`

**Fallback value**: `standard`

A hint to the accessibility runtime of how to 
prioritize this instance's label and description, relative to others. Allowed 
tokens are "low", "standard", and "high".

This attribute is optional and is considered a hint that runtimes may ignore.

Priority may not be time varying.

