% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 05:23PM on April 01, 2025


(Backdrop)=
# Backdrop

Backdrop is a visual indication of a grouping of 
nodes.
        
The Backdrop can take the form of a colored rectangle, making it easier to see 
node groupings in the node graph.

Consider the following example:

```{code-block} usda
def Material "MyMaterial"
{
    token outputs:mtlx:surface.connect = </World/Material/PreviewSurface.outputs:out>

    def Shader "PreviewSurface" (
        prepend apiSchemas = ["NodeGraphNodeAPI"]
    )
    {
        uniform token info:id = "ND_UsdPreviewSurface_surfaceshader"
        color3f inputs:diffuseColor.connect = </World/Material/Color.outputs:out>
        token outputs:out

        uniform float2 ui:nodegraph:node:pos = (-0.85, 1.9)
    }

    def Shader "Color" (
        prepend apiSchemas = ["NodeGraphNodeAPI"]
    )
    {
        uniform token info:id = "ND_constant_color3"
        color3f inputs:value = (1, 0.023, 0.701)
        color3f outputs:out

        uniform float2 ui:nodegraph:node:pos = (-2, 2)
    }

    def Backdrop "Backdrop" (
        prepend apiSchemas = ["NodeGraphNodeAPI"]
    )
    {
        uniform token ui:description = "MyMaterial Nodes"
        uniform color3f ui:nodegraph:node:displayColor = (1, 0, 0)
        uniform float2 ui:nodegraph:node:pos = (-0.8, 0.5)
        uniform float2 ui:nodegraph:node:size = (450, 330)
    }
}
```

Observe the positions, with the backdrop starting at an x-coordiante of -0.8, 
`PreviewSurface` at -0.85, and `Color` at -2.0. The backdrop’s width of 450 
highlights the contrast between size and position units. While a typical node 
may be around 200px wide, this setup ensures that the backdrop covers both nodes.
Observing the y-coordinates of 0.5, 1.9, and 2, it should be noted that the 
Y-coordinate increases as you move downward. This means the backdrop is 
positioned above both nodes and extends 330px downward. The backdrop appears in 
red and is labeled `MyMaterial Nodes`.

```{contents}
:depth: 2
:local:
:backlinks: none
```

(Backdrop_properties)=

## Properties

(Backdrop_ui:description)=

### ui:description

**USD type**: `token`

A description for the backdrop.

For example, when creating custom noise with multiple nodes, using a description 
of 'Noise' helps indicate that these nodes contribute to overall noise 
generation.

