% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 05:23PM on April 01, 2025


(NodeGraphNodeAPI)=
# NodeGraphNodeAPI

NodeGraphNodeAPI stores information about nodes 
within a node graph.

Nodes in node graphs have common attributes such as their position 
(`ui:nodegraph:node:pos`), color (`ui:nodegraph:node:displayColor`),
z-index or relative depth strength (`ui:nodegraph:node:stackingOrder`), among 
others. `NodeGraphNodeAPI` allows users to specify this type of node 
information.

The example below shows a typical use case for shader nodes with two nodes 
`Preview Surface` and `Color`. We can infer from the example the following 
information:
- We expect that the `Preview Surface` node will be red, while the `Color` node 
will be blue.
- The associated doc links are provided for the user to get more node info.
- `Preview Surface` is `open` and `Color` is `closed`. How the expansion state 
will be presented will depend on the context or tool the nodes are viewed in, 
but it's expected that `Preview Surface` reveals more information than `Color`.
- The icons come from different files and are meant to be descriptive for the 
nodes, not the content of the nodes.
- They are in different positions.
- `Preview Surface` node is larger than the `Color` node.
- If overlapping, `Color` will be shown above or on top of `Preview Surface`.

```{code-block} usda
def Material "MyMaterial"
{
    token outputs:mtlx:surface.connect = </World/MyMaterial/PreviewSurface.outputs:out>

    def Shader "PreviewSurface"
    {
        uniform token info:id = "ND_UsdPreviewSurface_surfaceshader"
        color3f inputs:diffuseColor.connect = </World/MyMaterial/Color.outputs:out>
        token outputs:out

        uniform color3f ui:nodegraph:node:displayColor = (1.0, 0.0, 0.0)
        uniform string ui:nodegraph:node:docURI = "https://openusd.org/release/spec_usdpreviewsurface.html"
        uniform token ui:nodegraph:node:expansionState = "open"
        uniform asset ui:nodegraph:node:icon = @preview_surface_icon.png@
        uniform float2 ui:nodegraph:node:pos = (-0.85, 1.9)
        uniform float2 ui:nodegraph:node:size = (300.0, 400.0)
        uniform int ui:nodegraph:node:stackingOrder = 1
    }

    def Shader "Color"
    {
        uniform token info:id = "ND_constant_color3"
        color3f inputs:value = (1.0, 0.023, 0.701)
        color3f outputs:out

        uniform color3f ui:nodegraph:node:displayColor = (0.0, 0.0, 1.0)
        uniform string ui:nodegraph:node:docURI = "https://github.com/AcademySoftwareFoundation/MaterialX/blob/main/documents/Specification/MaterialX.Specification.md#procedural-nodes"
        uniform token ui:nodegraph:node:expansionState = "closed"
        uniform asset ui:nodegraph:node:icon = @color_icon.png@
        uniform float2 ui:nodegraph:node:pos = (-2, 2)
        uniform float2 ui:nodegraph:node:size = (100.0, 200.0)
        uniform int ui:nodegraph:node:stackingOrder = 2
    }
}
```
        
```{contents}
:depth: 2
:local:
:backlinks: none
```

(NodeGraphNodeAPI_properties)=

## Properties

(NodeGraphNodeAPI_ui:nodegraph:node:displayColor)=

### ui:nodegraph:node:displayColor

**USD type**: `color3f`

The color of the node.

(NodeGraphNodeAPI_ui:nodegraph:node:docURI)=

### ui:nodegraph:node:docURI

**USD type**: `string`

A URI formatted link that points to 
documentation for the node.

(NodeGraphNodeAPI_ui:nodegraph:node:expansionState)=

### ui:nodegraph:node:expansionState

**USD type**: `token`

Shows the current size or status of the node. 
Either open, closed, or minimized.

(NodeGraphNodeAPI_ui:nodegraph:node:icon)=

### ui:nodegraph:node:icon

**USD type**: `asset`

An image to classify the node.

Meant to help describe the node itself, not the result of the action. For 
example with an Add node, an icon might be a + sign.


(NodeGraphNodeAPI_ui:nodegraph:node:pos)=

### ui:nodegraph:node:pos

**USD type**: `float2`

An x,y coordinate pair expressing the location 
of the node.

If the node has a parent, this position will be relative to the parent. 

The Y coordinate is intended to increase going down. For example -1.0 would be 
higher than 1.0. These units are not meant to be in pixel space, but represent 
the size of a typical node.


(NodeGraphNodeAPI_ui:nodegraph:node:size)=

### ui:nodegraph:node:size

**USD type**: `float2`

Optional x,y dimensions for the node, in pixels.

This is optional because the size of the node can be generated by its number of 
inputs and outputs.
            

(NodeGraphNodeAPI_ui:nodegraph:node:stackingOrder)=

### ui:nodegraph:node:stackingOrder

**USD type**: `int`

The order in which a node should be displayed in 
the case of overlapping nodes.

Nodes with higher stackingOrder values are intended to be drawn on top of nodes 
lower stackingOrder values.

