% WARNING: THIS FILE IS GENERATED BY genSchemaDocs. DO NOT EDIT.
% Generated: 04:05PM on May 16, 2024


(FieldAsset)=
# FieldAsset

FieldAsset is an abstract schema (that inherits
from {ref}`FieldBase`) that represents a volumetric field
where the volumetric data is stored outside the layer, e.g. in a file asset.
It is used as a base class for schemas that reference specific volume data
asset types, such as OpenVDB data. 

If you need to extend UsdVol with your own custom file-based field schemas, 
your custom schemas should inherit from FieldAsset.

```{admonition} Create Prims Using FieldAsset-derived Schemas
:class: note

Like FieldBase, FieldAsset is an abstract schema. In practice you will most
likely create prims using one of the field schemas that inherit from FieldAsset,
such as OpenVDBAsset or Field3DAsset.
```

```{contents}
:depth: 2
:local:
:backlinks: none
```

(FieldAsset_properties)=

## Properties

(FieldAsset_fieldDataType)=

### fieldDataType

**USD type**: `token`

The data type of a field, such as "float".

Use this attribute to tell consumers more about the field without requiring the 
consumer access the asset file directly. The list of allowed tokens is specified 
with the specific asset type. A missing value is considered an error.

(FieldAsset_fieldIndex)=

### fieldIndex

**USD type**: `int`

The index of a field within a FieldAsset asset
file. This attribute is optional.

An asset file can contain multiple fields with the same name. This optional 
attribute is an index used to disambiguate between multiple fields with the same 
name. For example, in an OpenVDB file asset, there might be two Grids named 
"density". A `fieldIndex` of 0 would specify that this Field refers to the first 
"density" Grid.


(FieldAsset_fieldName)=

### fieldName

**USD type**: `token`

Represents the name of an individual field within
a FieldAsset asset file. 

A FieldAsset file asset may contain multiple fields in a single asset file. This 
attribute specifies the name of field **within** the asset file. For example, an 
OpenVDB file asset might have multiple named Grids, such as "density", 
"temperature", etc. `fieldName` would specify one of the named Grids in the 
OpenVDB file asset.

Note that a Volume also provides a way to specify the "name" for a field, via 
the field relationship. This name is not associated with asset data and is used 
by the Volume for organizing fields for the rendering pipeline. See
{ref}`usdVol_understanding_fieldname` for more details on how the field's 
relationship name differs from `fieldName`.


(FieldAsset_filePath)=

### filePath

**USD type**: `asset`

An asset path attribute that points to a file on disk.

The asset pointed to by filePath must be a file type that the FieldAsset-derived
schema supports. For example, for OpenVDBAsset, the file type must be an 
OpenVDB (.vdb) file. For Field3DAsset, the file type must be a Field3D (.f3d)
file.

This attribute's value can be animated over time, as most
volume asset formats represent just a single timeSample of
a volume. However, it does not, at this time, support
any pattern substitutions like "$F". 

See {ref}`usdVol_using_animated_field_data` for an example of using `filePath`
to refer to animated volumetric data.


(FieldAsset_vectorDataRoleHint)=

### vectorDataRoleHint

**USD type**: `token`

**Fallback value**: `None`

Specifies the role of a vector valued field,
such as "Color". This can drive the data type in which fields are made available 
in a renderer or whether the vector values are to be transformed. This attribute 
is optional.

This token can drive the data type in which fields are made available in a 
renderer or whether the vector values are to be transformed. Allowed tokens 
include `None`, `Point`, `Normal`, `Vector`, and `Color`.


(FieldAsset_inheritedproperties_Xformable)=

## Inherited Properties ({ref}`Xformable`)

(FieldAsset_xformOpOrder)=

### xformOpOrder

**USD type**: `token[]`



(FieldAsset_inheritedproperties_Imageable)=

## Inherited Properties ({ref}`Imageable`)

(FieldAsset_proxyPrim)=

### proxyPrim

**USD type**: `rel` (relationship)



(FieldAsset_purpose)=

### purpose

**USD type**: `token`

**Fallback value**: `default`



(FieldAsset_visibility)=

### visibility

**USD type**: `token`

**Fallback value**: `inherited`


