//
// Copyright 2021 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// dualQuat.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/dualQuat{{ SUFFIX }}.h"
#include "pxr/base/gf/ostreamHelpers.h"
#include "pxr/base/tf/type.h"

{% for S in SCALARS if S != SCL -%}
#include "pxr/base/gf/dualQuat{{ SCALAR_SUFFIX(S) }}.h"
{% endfor %}

PXR_NAMESPACE_OPEN_SCOPE

TF_REGISTRY_FUNCTION(TfType) {
    TfType::Define<{{ DUALQUAT }}>();
}

{% for S in SCALARS if S != SCL %}
{{ DUALQUAT }}::{{ DUALQUAT }}(const {{ DUALQUATNAME(S) }} &other)
    : _real(other.GetReal()) , _dual(other.GetDual())
{
}
{% endfor %}

std::pair<{{ SCL }}, {{ SCL }}>
{{ DUALQUAT }}::GetLength() const
{
    const {{ SCL }} realLength = _real.GetLength();

    if (realLength == 0)
        return std::pair<{{ SCL }}, {{ SCL }}>{0, 0};

    return std::pair<{{ SCL }}, {{ SCL }}>{ realLength, GfDot(_real, _dual)/realLength };
}

{{ DUALQUAT }}
{{ DUALQUAT }}::GetNormalized({{ SCL }} eps) const
{
    {{ DUALQUAT }} dq(*this);
    dq.Normalize(eps);

    return dq;
}

std::pair<{{ SCL }}, {{ SCL }}>
{{ DUALQUAT }}::Normalize({{ SCL }} eps)
{
    const std::pair<{{ SCL }}, {{ SCL }}> length = GetLength();
    const {{ SCL }} realLength = length.first;

    if (realLength < eps) {
        (*this) = {{ DUALQUAT }}::GetIdentity();
    } else {
        const {{ SCL }} invRealLength = 1.0 / realLength;
        _real *= invRealLength;
        _dual *= invRealLength;

        _dual -= (GfDot(_real, _dual) * _real);
    }

    return length;
}

{{ DUALQUAT }}
{{ DUALQUAT }}::GetConjugate() const
{
    return {{ DUALQUAT }}( _real.GetConjugate(), _dual.GetConjugate() );
}

{{ DUALQUAT }}
{{ DUALQUAT }}::GetInverse() const
{
    // DQ * DQ.GetInverse() == GetIdentity()
    const {{ SCL }} realLengthSqr = GfDot(_real, _real);

    if ( realLengthSqr <= 0.0 )
        return {{ DUALQUAT }}::GetIdentity();

    const {{ SCL }} invRealLengthSqr = 1.0 / realLengthSqr;
    const {{ DUALQUAT }} conjInvLenSqr = GetConjugate() * invRealLengthSqr;
    const {{ QUAT }} realPart = conjInvLenSqr.GetReal();
    const {{ QUAT }} dualPart = conjInvLenSqr.GetDual() -
        (2.0 * invRealLengthSqr * GfDot(_real, _dual) * conjInvLenSqr.GetReal());

    return {{ DUALQUAT }}( realPart, dualPart );
}

void
{{ DUALQUAT }}::SetTranslation( const GfVec3{{ SUFFIX }} &translation )
{
    // compute and set the dual part
    _dual = {{ QUAT }}( 0.0, 0.5*translation ) * _real;
}

GfVec3{{ SUFFIX }}
{{ DUALQUAT }}::GetTranslation() const
{
    // _dual = {{ QUAT }}(0, 0.5*translation) * _real
    // => translation = 2 * (_dual * _real.GetConjugate()).GetImaginary()

    // Assume that this dual quaternion is normalized
    TF_DEV_AXIOM(GfIsClose(_real.GetLength(), 1.0, 0.001));
    const {{ SCL }} r1 = _dual.GetReal();
    const {{ SCL }} r2 = _real.GetReal();
    const GfVec3{{ SUFFIX }} &i1 = _dual.GetImaginary();
    const GfVec3{{ SUFFIX }} &i2 = _real.GetImaginary();

    // Translation of the dual quaternion: -2.0 * (r1*i2 - r2*i1 + i1^i2)
    return GfVec3{{ SUFFIX }}( -2.0*(r1*i2[0] - r2*i1[0] + (i1[1]*i2[2] - i1[2]*i2[1])),
                               -2.0*(r1*i2[1] - r2*i1[1] + (i1[2]*i2[0] - i1[0]*i2[2])),
                               -2.0*(r1*i2[2] - r2*i1[2] + (i1[0]*i2[1] - i1[1]*i2[0])) );
}

{{ DUALQUAT }} &
{{ DUALQUAT }}::operator *=(const {{ DUALQUAT }} &dq)
{
    const {{ QUAT }} tempReal = GetReal() * dq.GetReal();
    const {{ QUAT }} tempDual = GetReal() * dq.GetDual() + GetDual() * dq.GetReal();

    SetReal(tempReal);
    SetDual(tempDual);

    return *this;
}

GfVec3{{ SUFFIX }}
{{ DUALQUAT }}::Transform(const GfVec3{{ SUFFIX }} &vec) const
{
    // Apply rotation and translation
    return GetReal().Transform(vec) + GetTranslation();
}

std::ostream &
operator<<(std::ostream &out, const {{ DUALQUAT }} &dq)
{
    return(out << '(' << Gf_OstreamHelperP(dq.GetReal()) << ", "
           << Gf_OstreamHelperP(dq.GetDual()) << ')');
}

PXR_NAMESPACE_CLOSE_SCOPE
