//
// Copyright 2021 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// dualQuat.template.h file to make changes.

#ifndef PXR_BASE_GF_{{ UPPER(DUALQUAT)[2:] }}_H
#define PXR_BASE_GF_{{ UPPER(DUALQUAT)[2:] }}_H

/// \file gf/dualQuat{{ SUFFIX }}.h
/// \ingroup group_gf_LinearAlgebra

#include "pxr/pxr.h"
#include "pxr/base/gf/api.h"
#include "pxr/base/gf/declare.h"
#include "pxr/base/gf/traits.h"
{% if SCL == 'GfHalf' -%}
#include "pxr/base/gf/half.h"
{% endif %}

#include "pxr/base/gf/quat{{ SUFFIX }}.h"
#include "pxr/base/tf/hash.h"

#include <iosfwd>

PXR_NAMESPACE_OPEN_SCOPE

template <>
struct GfIsGfDualQuat<class {{ DUALQUAT }}> { static const bool value = true; };

/// Return the dot (inner) product of two dual quaternions.
{{ SCL }} GfDot(const {{ DUALQUAT }}& dq1, const {{ DUALQUAT }}& dq2);


/// \class {{ DUALQUAT }}
/// \ingroup group_gf_LinearAlgebra
///
/// Basic type: a real part quaternion and a dual part quaternion.
///
/// This class represents a generalized dual quaternion that has a real part
/// and a dual part quaternions. Dual quaternions are used to represent a
/// combination of rotation and translation.
///
/// References:
///    https://www.cs.utah.edu/~ladislav/kavan06dual/kavan06dual.pdf
///    https://faculty.sites.iastate.edu/jia/files/inline-files/dual-quaternion.pdf
///
class {{ DUALQUAT }} final
{
  public:
    typedef {{ SCL }} ScalarType;

    /// The default constructor leaves the dual quaternion undefined.
    {{ DUALQUAT }}() {}

    /// Initialize the real part to \p realVal and the imaginary part
    /// to zero quaternion.
    ///
    /// Since quaternions typically must be normalized, reasonable values for
    /// \p realVal are -1, 0, or 1.  Other values are legal but are likely to
    /// be meaningless.
    ///
    explicit {{ DUALQUAT }}( {{ SCL }} realVal ) : _real( realVal ), _dual( 0 ) {}

    /// Initialize the real part to \p real quaternion and the imaginary part
    /// to zero quaternion.
    ///
    explicit {{ DUALQUAT }}( const {{ QUAT }} &real )
        : _real( real ), _dual( 0 ) {
    }

    /// This constructor initializes the real and dual parts.
    {{ DUALQUAT }}( const {{ QUAT }} &real, const {{ QUAT }} &dual )
        : _real( real ), _dual( dual ) {
    }

    /// This constructor initializes from a rotation and a translation components.
    {{ DUALQUAT }}( const {{ QUAT }} &rotation, const GfVec3{{ SUFFIX }} &translation )
        : _real( rotation ) {
        SetTranslation( translation );
    }

{% for S in SCALARS if S != SCL %}
    /// {{ "Implicitly convert" if ALLOW_IMPLICIT_CONVERSION(S, SCL) else "Construct" }} from {{ DUALQUATNAME(S) }}.
    GF_API
    {{ '' if ALLOW_IMPLICIT_CONVERSION(S, SCL) else 'explicit ' }}{{ DUALQUAT }}(const {{ DUALQUATNAME(S) }} &other);
{% endfor %}

    /// Sets the real part of the dual quaternion.
    void SetReal(const {{ QUAT }} &real) {
        _real  = real;
    }

    /// Sets the dual part of the dual quaternion.
    void SetDual(const {{ QUAT }} &dual) {
        _dual  = dual;
    }

    /// Returns the real part of the dual quaternion.
    const {{ QUAT }} &GetReal() const {
        return _real;
    }

    /// Returns the dual part of the dual quaternion.
    const {{ QUAT }} &GetDual() const {
        return _dual;
    }

    /// Returns the zero dual quaternion, which has a real part of (0,0,0,0) and
    /// a dual part of (0,0,0,0).
    static {{ DUALQUAT }} GetZero() {
        return {{ DUALQUAT }}({{ QUAT }}::GetZero(), {{ QUAT }}::GetZero());
    }

    /// Returns the identity dual quaternion, which has a real part of (1,0,0,0) and
    /// a dual part of (0,0,0,0).
    static {{ DUALQUAT }} GetIdentity() {
        return {{ DUALQUAT }}({{ QUAT }}::GetIdentity(), {{ QUAT }}::GetZero());
    }

    /// Returns geometric length of this dual quaternion.
    GF_API
    std::pair<{{ SCL }}, {{ SCL }}> GetLength() const;

    /// Returns a normalized (unit-length) version of this dual quaternion.
    /// If the length of this dual quaternion is smaller than \p
    /// eps, this returns the identity dual quaternion.
    GF_API
    {{ DUALQUAT }} GetNormalized({{ SCL }} eps = GF_MIN_VECTOR_LENGTH) const;

    /// Normalizes this dual quaternion in place.
    /// Normalizes this dual quaternion in place to unit length, returning the
    /// length before normalization. If the length of this dual quaternion is
    /// smaller than \p eps, this sets the dual quaternion to identity.
    GF_API
    std::pair<{{ SCL }}, {{ SCL }}> Normalize({{ SCL }} eps = GF_MIN_VECTOR_LENGTH);

    /// Returns the conjugate of this dual quaternion.
    GF_API
    {{ DUALQUAT }} GetConjugate() const;

    /// Returns the inverse of this dual quaternion.
    GF_API
    {{ DUALQUAT }} GetInverse() const;

    /// Set the translation component of this dual quaternion.
    GF_API
    void SetTranslation( const GfVec3{{ SUFFIX }} &translation );

    /// Get the translation component of this dual quaternion.
    GF_API
    GfVec3{{ SUFFIX }} GetTranslation() const;

    /// Hash.
    friend inline size_t hash_value(const {{ DUALQUAT }} &dq) {
        return TfHash::Combine(dq.GetReal(), dq.GetDual());
    }

    /// Component-wise dual quaternion equality test. The real and dual parts
    /// must match exactly for dual quaternions to be considered equal.
    bool operator ==(const {{ DUALQUAT }} &dq) const {
        return (GetReal() == dq.GetReal() &&
                GetDual() == dq.GetDual());
    }

    /// Component-wise dual quaternion inequality test. The real and dual
    /// parts must match exactly for dual quaternions to be considered equal.
    bool operator !=(const {{ DUALQUAT }} &dq) const {
        return ! (*this == dq);
    }

    /// Component-wise unary sum operator.
    {{ DUALQUAT }} &operator +=(const {{ DUALQUAT }} &dq)  {
        _real += dq._real;
        _dual += dq._dual;
        return *this;
    }

    /// Component-wise unary difference operator.
    {{ DUALQUAT }} &operator -=(const {{ DUALQUAT }} &dq)  {
        _real -= dq._real;
        _dual -= dq._dual;
        return *this;
    }

    /// Post-multiplies dual quaternion \p dq into this dual quaternion.
    GF_API
    {{ DUALQUAT }} &operator *=(const {{ DUALQUAT }} &dq);

    /// Scales this dual quaternion by \p s.
    {{ DUALQUAT }} &operator *=({{ SCL }} s) {
        _real *= s;
        _dual *= s;
        return *this;
    }

    /// Scales this dual quaternion by 1 / \p s.
    {{ DUALQUAT }} &operator /=({{ SCL }} s) {
        return (*this) *= 1.0 / s;
    }

    /// Component-wise binary sum operator.
    friend {{ DUALQUAT }} operator +(const {{ DUALQUAT }} &dq1,
                                     const {{ DUALQUAT }} &dq2) {
        {{ DUALQUAT }} dqt = dq1;
        return dqt += dq2;
    }

    /// Component-wise binary difference operator.
    friend {{ DUALQUAT }} operator -(const {{ DUALQUAT }} &dq1,
                                     const {{ DUALQUAT }} &dq2) {
        {{ DUALQUAT }} dqt = dq1;
        return dqt -= dq2;
    }

    /// Returns the product of dual quaternions \p dq1 and \p dq2.
    friend {{ DUALQUAT }} operator *(const {{ DUALQUAT }} &dq1,
                                     const {{ DUALQUAT }} &dq2) {
        {{ DUALQUAT }} dqt  = dq1;
        return dqt *= dq2;
    }

    /// Returns the product of dual quaternion \p dq and scalar \p s.
    friend {{ DUALQUAT }} operator *(const {{ DUALQUAT }} &dq, {{ SCL }} s) {
        {{ DUALQUAT }} dqt  = dq;
        return dqt *= s;
    }

    /// Returns the product of dual quaternion \p dq and scalar \p s.
    friend {{ DUALQUAT }} operator *({{ SCL }} s, const {{ DUALQUAT }} &dq) {
        {{ DUALQUAT }} dqt  = dq;
        return dqt *= s;
    }

    /// Returns the product of dual quaternion \p dq and scalar 1 / \p s.
    friend {{ DUALQUAT }} operator /(const {{ DUALQUAT }} &dq, {{ SCL }} s) {
        {{ DUALQUAT }} dqt  = dq;
        return dqt /= s;
    }

    /// Transforms the row vector \e vec by the dual quaternion.
    GF_API
    GfVec3{{ SUFFIX }} Transform(const GfVec3{{ SUFFIX }} &vec) const;

  private:
    {{ QUAT }} _real;   // for rotation
    {{ QUAT }} _dual;   // for translation
};


/// Output a {{ DUALQUAT }} using the format ((rw, rx, ry, rz), (dw, dx, dy, dz)).
/// \ingroup group_gf_DebuggingOutput
GF_API std::ostream &operator<<(std::ostream &out, const {{ DUALQUAT }} &dq);


/// Returns the dot (inner) product of two dual quaternions.
inline {{ SCL }}
GfDot(const {{ DUALQUAT }}& dq1, const {{ DUALQUAT }}& dq2) {
    return GfDot(dq1.GetReal(), dq2.GetReal()) + GfDot(dq1.GetDual(), dq2.GetDual());
}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // PXR_BASE_GF_{{ UPPER(DUALQUAT)[2:] }}_H
