//
// Copyright 2021 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapDualQuat.template.cpp file to make changes.

#include "pxr/pxr.h"
{% for S in SCALARS %}
#include "pxr/base/gf/dualQuat{{ SCALAR_SUFFIX(S) }}.h"
{% endfor %}

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/copy_const_reference.hpp"
#include "pxr/external/boost/python/def.hpp"
#include "pxr/external/boost/python/implicit.hpp"
#include "pxr/external/boost/python/make_constructor.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/overloads.hpp"
#include "pxr/external/boost/python/return_arg.hpp"

#include <string>

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

static string __repr__({{ DUALQUAT }} const &self) {
    return TF_PY_REPR_PREFIX + "DualQuat{{ SUFFIX }}(" +
        TfPyRepr(self.GetReal()) + ", " +
        TfPyRepr(self.GetDual()) + ")";
}

static {{ DUALQUAT }} __truediv__(const {{ DUALQUAT }} &self, {{ SCL }} value)
{
    return self / value;
}

static {{ DUALQUAT }}& __itruediv__({{ DUALQUAT }} &self, {{ SCL }} value)
{
    return self /= value;
}

static size_t __hash__({{ DUALQUAT }} const &self) {
    return TfHash{}(self);
}

// Zero-initialized default ctor for python.
static {{ DUALQUAT }} *__init__() {
    return new {{ DUALQUAT }}({{ QUAT }}(0), {{ QUAT }}(0));
}

} // anonymous namespace

void wrapDualQuat{{ SUFFIX }}()
{
    object getReal =
        make_function(&{{ DUALQUAT }}::GetReal,
                      return_value_policy<return_by_value>());
    object setReal =
        make_function((void ({{ DUALQUAT }}::*)(const {{ QUAT }} &))
                      &{{ DUALQUAT }}::SetReal);

    object getDual =
        make_function(&{{ DUALQUAT }}::GetDual,
                      return_value_policy<return_by_value>());
    object setDual =
        make_function((void ({{ DUALQUAT }}::*)(const {{ QUAT }} &))
                      &{{ DUALQUAT }}::SetDual);

    def( "Dot",
         ({{ SCL }} (*)(const {{ DUALQUAT }} &, const {{ DUALQUAT }} &))
         GfDot);

    class_<{{ DUALQUAT }}> cls("DualQuat{{ SUFFIX }}", no_init);
    cls
        .def("__init__", make_constructor(__init__))

        .def( TfTypePythonClass() )

        .def(init<GfDualQuat{{ SUFFIX }}>())
        .def(init<{{ SCL }}>(arg("realVal")))
        .def(init< const {{ QUAT }} & >(arg("real")))
        .def(init< const {{ QUAT }} &, const {{ QUAT }} & >(
                 (arg("real"), arg("dual"))))
        .def(init< const {{ QUAT }} &, const GfVec3{{ SUFFIX }} & >(
                 (arg("rotation"), arg("translation"))))
{% for S in SCALARS if S != SCL and not ALLOW_IMPLICIT_CONVERSION(S, SCL) %}
        .def(init<const GfDualQuat{{ SCALAR_SUFFIX(S) }} & >())
{% endfor %}

        .def("GetZero", &{{ DUALQUAT }}::GetZero)
        .staticmethod("GetZero")

        .def("GetIdentity", &{{ DUALQUAT }}::GetIdentity)
        .staticmethod("GetIdentity")

        .def("GetReal", getReal)
        .def("SetReal", setReal)
        .add_property("real", getReal, setReal)

        .def("GetDual", getDual)
        .def("SetDual", setDual)
        .add_property("dual", getDual, setDual)

        .def("GetLength", &{{ DUALQUAT }}::GetLength)

        .def("GetNormalized", &{{ DUALQUAT }}::GetNormalized,
             (arg("eps")=GF_MIN_VECTOR_LENGTH))
        .def("Normalize", &{{ DUALQUAT }}::Normalize,
             (arg("eps")=GF_MIN_VECTOR_LENGTH), return_self<>())

        .def("GetConjugate", &{{ DUALQUAT }}::GetConjugate)
        .def("GetInverse", &{{ DUALQUAT }}::GetInverse)
        .def("SetTranslation",
             (void ({{ DUALQUAT }}::*)(const GfVec3{{ SUFFIX }} &))
             &{{ DUALQUAT }}::SetTranslation)
        .def("GetTranslation", &{{ DUALQUAT }}::GetTranslation)

        .def("Transform",
             (GfVec3{{ SUFFIX }} ({{ DUALQUAT }}::*)(const GfVec3{{ SUFFIX }} &) const)
             &{{ DUALQUAT }}::Transform)

        .def( str(self) )
        .def( self == self )
        .def( self != self )
        .def( self += self )
        .def( self -= self )
        .def( self *= self )
        .def( self *= {{ SCL }}() )
        .def( self /= {{ SCL }}() )
        .def( self + self )
        .def( self - self )
        .def( self * self )
        .def( self * {{ SCL }}() )
        .def( {{ SCL }}() * self )
        .def( self / {{ SCL }}() )

        .def("__repr__", __repr__)
        .def("__hash__", __hash__)
        ;

{% for S in SCALARS if S != SCL and ALLOW_IMPLICIT_CONVERSION(S, SCL) %}
    implicitly_convertible<{{ DUALQUATNAME(S) }}, {{ DUALQUAT }}>();
{% endfor %}

    to_python_converter<std::vector<{{ DUALQUAT }}>,
        TfPySequenceToPython<std::vector<{{ DUALQUAT }}> > >();

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / {{ SCL }}() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__);
    }
    if (!PyObject_HasAttrString(cls.ptr(), "__itruediv__")) {
        // __itruediv__ not added by .def( self /= {{ SCL }}() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division". This is also a workaround for a 
        // bug in the current version of pxr_boost::python that incorrectly wraps
        // in-place division with __idiv__ when building with python 3.
        cls.def("__itruediv__", __itruediv__, return_self<>());
    }
}
