//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapMatrix4.template.cpp file to make changes.

#ifndef PXR_BOOST_PYTHON_MAX_ARITY
#define PXR_BOOST_PYTHON_MAX_ARITY 20
#endif

{% extends "wrapMatrix.template.cpp" %}

{% block customIncludes %}
#include "pxr/base/gf/matrix3{{ SCL[0] }}.h"
#include "pxr/base/gf/quat{{ SCL[0] }}.h"
#include "pxr/base/gf/rotation.h"
{% endblock customIncludes %}

{% block customFunctions %}
static tuple FactorWithEpsilon({{ MAT }} &self, double eps) {
    {{ MAT }} r, u, p;
    GfVec3{{ SCL[0] }} s, t;
    bool result = self.Factor(&r, &s, &u, &t, &p, eps);
    return pxr_boost::python::make_tuple(result, r, s, u, t, p);
}    

static tuple Factor({{ MAT }} &self) {
    {{ MAT }} r, u, p;
    GfVec3{{ SCL[0] }} s, t;
    bool result = self.Factor(&r, &s, &u, &t, &p);
    return pxr_boost::python::make_tuple(result, r, s, u, t, p);
}

static {{ MAT }} RemoveScaleShearWrapper( const {{ MAT }} &self ) {
    return self.RemoveScaleShear();
}
{% endblock customFunctions %}

{% block customInit %}
        .def(init< const vector<float>&,
                   const vector<float>&,
                   const vector<float>&,
                   const vector<float>& >())
        .def(init< const vector<double>&,
                   const vector<double>&,
                   const vector<double>&,
                   const vector<double>& >())
        .def(init< const GfMatrix3{{ SCL[0] }} &, const GfVec3{{ SCL[0] }} >())
        .def(init< const GfRotation &, const GfVec3{{ SCL[0] }} >())
{% endblock customInit %}

{% block customDefs %}
        .def("GetRow3", &This::GetRow3)
        .def("SetRow3", &This::SetRow3)
        .def("GetDeterminant3", &This::GetDeterminant3)
        .def("HasOrthogonalRows3", &This::HasOrthogonalRows3)

        .def("GetHandedness", &This::GetHandedness)
        .def("IsLeftHanded", &This::IsLeftHanded)
        .def("IsRightHanded", &This::IsRightHanded)

        .def("Orthonormalize", &This::Orthonormalize,
             (arg("issueWarning") = true))
        .def("GetOrthonormalized", &This::GetOrthonormalized,
             (arg("issueWarning") = true))
{% endblock customDefs %}

{% block customXformDefs %}
        .def("SetTransform",
	     (This & (This::*)( const GfRotation &,
				const GfVec3{{ SCL[0] }} & ))&This::SetTransform,
	     return_self<>())	
        .def("SetTransform",
	     (This & (This::*)( const GfMatrix3{{ SCL[0] }}&,
				const GfVec3{{ SCL[0] }} & ))&This::SetTransform,
	     return_self<>())

        .def("SetScale", (This & (This::*)( const GfVec3{{ SCL[0] }}& ))&This::SetScale,
	     return_self<>())

        .def("SetTranslate", &This::SetTranslate, return_self<>())
        .def("SetTranslateOnly", &This::SetTranslateOnly, return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfQuat{{ SCL[0] }} & )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfQuat{{ SCL[0] }} & )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfRotation & )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfRotation & )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfMatrix3{{ SCL[0] }}& )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfMatrix3{{ SCL[0] }}& )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetLookAt", (This & (This::*)( const GfVec3{{ SCL[0] }} &,
                                             const GfVec3{{ SCL[0] }} &,
                                             const GfVec3{{ SCL[0] }} & ))&This::SetLookAt,
	     return_self<>())

        .def("SetLookAt",
             (This & (This::*)( const GfVec3{{ SCL[0] }} &,
                                const GfRotation & ))&This::SetLookAt,
             return_self<>())

        .def("ExtractTranslation", &This::ExtractTranslation)
        .def("ExtractRotation", &This::ExtractRotation)
        .def("ExtractRotationMatrix", &This::ExtractRotationMatrix)
        .def("ExtractRotationQuat", &This::ExtractRotationQuat)

        .def("Factor", FactorWithEpsilon)
        .def("Factor", Factor)
        .def("RemoveScaleShear", RemoveScaleShearWrapper)
        
{% if SCL == 'double' %}
        // Provide wrapping that makes up for the fact that, in Python, we
        // don't allow implicit conversion from GfVec3f to GfVec3d (which we
        // do in C++).
        .def("Transform",
	     +[](const This &self, const GfVec3f &p) -> GfVec3d {
                 return self.Transform(p);
             })
{% else %}
        .def("Transform",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::Transform)
{% endif %}
        .def("Transform",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::Transform)

{% if SCL == 'double' %}
        // Provide wrapping that makes up for the fact that, in Python, we
        // don't allow implicit conversion from GfVec3f to GfVec3d (which we
        // do in C++).
        .def("TransformDir",
	     +[](const This &self, const GfVec3f &p) -> GfVec3d {
                 return self.TransformDir(p);
             })
{% else %}
        .def("TransformDir",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::TransformDir)
{% endif %}
        .def("TransformDir",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::TransformDir)

{% if SCL == 'double' %}
        // Provide wrapping that makes up for the fact that, in Python, we
        // don't allow implicit conversion from GfVec3f to GfVec3d (which we
        // do in C++).
        .def("TransformAffine",
	     +[](const This &self, const GfVec3f &p) -> GfVec3d {
                 return self.TransformAffine(p);
             })
{% else %}
        .def("TransformAffine",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::TransformAffine)
{% endif %}
        .def("TransformAffine",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::TransformAffine)
        .def("SetScale", (This & (This::*)( {{ SCL }} ))&This::SetScale,
	     return_self<>())

{% endblock customXformDefs %}
