//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapRange.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/range{{ SUFFIX }}.h"
{% for S in SCALARS if S != SCL %}
#include "pxr/base/gf/range{{ DIM }}{{ S[0] }}.h"
{% endfor %}

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/copy_const_reference.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/return_arg.hpp"

#include <string>

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

static const int _dimension = {{ DIM }};

static string _Repr({{ RNG }} const &self) {
    return TF_PY_REPR_PREFIX + "Range{{ SUFFIX }}(" +
        TfPyRepr(self.GetMin()) + ", " + TfPyRepr(self.GetMax()) + ")";
}

static {{ RNG }} __truediv__(const {{ RNG }} &self, double value)
{
    return self / value;
}

static {{ RNG }}& __itruediv__({{ RNG }} &self, double value)
{
    return self /= value;
}

static size_t __hash__({{ RNG }} const &r) { return TfHash{}(r); }

} // anonymous namespace 

void wrapRange{{ SUFFIX }}()
{    
    object getMin = make_function(&{{ RNG }}::GetMin,
                                  return_value_policy<return_by_value>());

    object getMax = make_function(&{{ RNG }}::GetMax,
                                  return_value_policy<return_by_value>());

    class_<{{ RNG }}> cls("Range{{ SUFFIX }}", init<>());
    cls
        .def(init<{{ RNG }}>())
        .def(init<{{ MINMAXPARM }}, {{ MINMAXPARM }}>())

{% for S in SCALARS if S != SCL %}
        .def(init<{{ RNGNAME(DIM, S) }}>())
{% endfor %}
        
        .def(TfTypePythonClass())

        .def_readonly("dimension", _dimension)
        
        .add_property("min", getMin, &{{ RNG }}::SetMin)
        .add_property("max", getMax, &{{ RNG }}::SetMax)

        .def("GetMin", getMin)
        .def("GetMax", getMax)

        .def("GetSize", &{{ RNG }}::GetSize)
        .def("GetMidpoint", &{{ RNG }}::GetMidpoint)
    
        .def("SetMin", &{{ RNG }}::SetMin)
        .def("SetMax", &{{ RNG }}::SetMax)
    
        .def("IsEmpty", &{{ RNG }}::IsEmpty)
    
        .def("SetEmpty", &{{ RNG }}::SetEmpty)

        .def("Contains", (bool ({{ RNG }}::*)({{ MINMAXPARM }}) const)
             &{{ RNG }}::Contains)
        .def("Contains", (bool ({{ RNG }}::*)(const {{ RNG }} &) const)
             &{{ RNG }}::Contains)
    
        .def("GetUnion", &{{ RNG }}::GetUnion)
        .staticmethod("GetUnion")
    
        .def("UnionWith", (const {{ RNG }} & ({{ RNG }}::*)({{ MINMAXPARM }}))
             &{{ RNG }}::UnionWith, return_self<>())
        .def("UnionWith", (const {{ RNG }} & ({{ RNG }}::*)(const {{ RNG }} &))
             &{{ RNG }}::UnionWith, return_self<>())
    
        .def("GetIntersection", &{{ RNG }}::GetIntersection)
        .staticmethod("GetIntersection")
    
        .def("IntersectWith", (const {{ RNG }} & ({{ RNG }}::*)(const {{ RNG }} &))
             &{{ RNG }}::IntersectWith, return_self<>())
    
        .def("GetDistanceSquared", &{{ RNG }}::GetDistanceSquared)
    
        .def(str(self))
        .def(self += self)
        .def(self -= self)
        .def(self *= double())
        .def(self /= double())
        .def(self + self)
        .def(self - self)
        .def(double() * self)
        .def(self * double())
        .def(self / double())
{% for S in SCALARS if S != SCL %}
        .def(self == {{ RNGNAME(DIM, S) }}())
        .def(self != {{ RNGNAME(DIM, S) }}())
{% endfor %}
        .def(self == self)
        .def(self != self)
        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

{% if DIM == 2 %}
        .def("GetCorner", &{{ RNG }}::GetCorner)
        .def("GetQuadrant", &{{ RNG }}::GetQuadrant)
        .def_readonly("unitSquare", &{{ RNG }}::UnitSquare)
{% elif DIM == 3 %}
        .def("GetCorner", &{{ RNG }}::GetCorner)
        .def("GetOctant", &{{ RNG }}::GetOctant)
        .def_readonly("unitCube", &{{ RNG }}::UnitCube)
{% endif %}
        
        ;
    to_python_converter<std::vector<{{ RNG }}>,
        TfPySequenceToPython<std::vector<{{ RNG }}> > >();

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__);
    }
    if (!PyObject_HasAttrString(cls.ptr(), "__itruediv__")) {
        // __itruediv__ not added by .def( self /= double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division". This is also a workaround for a 
        // bug in the current version of pxr_boost::python that incorrectly wraps
        // in-place division with __idiv__ when building with python 3.
        cls.def("__itruediv__", __itruediv__, return_self<>());
    }

}
