//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MATERIAL_SCHEMA_H
#define PXR_IMAGING_HD_MATERIAL_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/materialNetworkSchema.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_MATERIAL_SCHEMA_TOKENS \
    (material) \
    ((universalRenderContext, "")) \
    ((all, "__all")) \
    (terminals) \
    (surface) \
    (displacement) \
    (volume) \

TF_DECLARE_PUBLIC_TOKENS(HdMaterialSchemaTokens, HD_API,
    HD_MATERIAL_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// The Material schema is a container schema that provides the correct
// material definition per render context.
//
// For example, a material may specify several render contexts like the
// universalRenderContext (""), Renderman ("ri"), Storm ("glslfx"), etc. Each
// render context will then provide the specific definition for the renderer,
// which is defined by the MaterialNetwork schema. The universalRenderContext
// applies to all renderers.
//
// See "Custom Code: Schema Methods" section for ASCII art diagram.
//

class HdMaterialSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMaterialSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "material" from the parent container and constructs a
    /// HdMaterialSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdMaterialSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--

    /// \name ASCII Art Diagram
    /// @{

    /// The following diagram depicts an example scene index prim 
    /// "Plastic_Material". "Plastic_Material" is a scene index prim that has 
    /// multiple container data sources, like 'material' (HdMaterialSchema) and 
    /// 'materialOverride' (HdMaterialOverrideSchema). "Plastic_Material" as a 
    /// scene index prim also has a scene index prim type, which is type 
    /// 'material'.  (See HdPrimTypeTokens).

    /// Note the following:
    /// 1. The data flows from left to right.
    /// 2. The lines between "materialOverride" and "interfaceMappings" 
    ///     are not true connections and are not backed by the 
    ///     MaterialConnection schema. Each item within "materialOverride"
    ///     and "interfaceMappings" is loosely coupled by their matching 
    ///     names.
    /// 3. The connections in the diagram are drawn with an 'o' to indicate
    ///     the source where the connection was authored, and these 
    ///     connections are backed by the MaterialConnection schema. 
        
    /// +----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
    /// |                                                                                                                                                                                                          |
    /// |  "Plastic_Material" [scene index prim name]                                                                                                                                                              |
    /// |                                                                                                                                                                                                          |
    /// | +-----------------------------------+      +--------------------------------------------------------------------------------------------------------------------------------------------------------+    |
    /// | | materialOverride                  |      | material                                                                                                                                               |    |
    /// | |  +------------------------------+ |      |  +--------------------------------------------------------------------------------------------------------------------------------------------------+  |    |
    /// | |  | interfaceValues              | |      |  | ri [materialNetwork for Renderman render context]                                                                                                |  |    |
    /// | |  |                              | |      |  |    +-----------------------+       +--------------------------------------------------------------------------------+   +-------------------+    |  |    |
    /// | |  | *globalVal = 0.2-------------+-+----+ |  |    |interfaceMappings      |       | nodes                                                                          |   |terminals          |    |  |    |
    /// | |  |                              | |    | |  |    |                       |       | +--------------------+                                                         |   |                   |    |  |    |
    /// | |  | *globalSpecularKface = 0.666-+-+-+  +-+--+--+-+*globalVal o-----------+---+   | |"Color_Manipulate"  |                                                         | +-+-o*surface         |    |  |    |
    /// | |  |                              | | |    |  |    |                       |   |   | |[materialNode]      |                                                         | | |                   |    |  |    |
    /// | |  +------------------------------+ | +--+-+--+--+-+*globalSpecularKface o-+-+ |   | |                    |                                                         | | |                   |    |  |    |
    /// | |                                   |      |  |    |                       | | +---+-+-*adjustVal     *out+----+                                                    | | +-------------------+    |  |    |
    /// | +-----------------------------------+      |  |    +-----------------------+ | |   | |                    |    |                                                    | |                          |  |    |
    /// |                                            |  |                              | |   | +--------------------+    |  +-----------------------+  +--------------------+ | |                          |  |    |
    /// |                                            |  |                              | |   |                           |  |"MaterialLayer"        |  |"PxrSurface"        | | |                          |  |    |
    /// |                                            |  |                              | |   |                           |  |[materialNode]         |  |[materialNode]      | | |                          |  |    |
    /// |                                            |  |                              | |   |                           |  |                       |  |                    | | |                          |  |    |
    /// |                                            |  |                              +-+---+---------------------------+--+--*specularKface   *out+--+-o*materialIn   *out+-+-+                          |  |    |
    /// |                                            |  |                                |   |                           |  |                       |  |                    | |                            |  |    |
    /// |                                            |  |                                |   |                           |  |  *diffuseK = 0.12     |  |                    | |                            |  |    |
    /// |                                            |  |                                |   | +----------------------+  |  |                       |  +--------------------+ |                            |  |    |
    /// |                                            |  |                                |   | |"Color_RetargetLayer" |  |  |                       |                         |                            |  |    |
    /// |                                            |  |                                |   | |[materialNode]        |  +--+-o*someInput_A         |                         |                            |  |    |
    /// |                                            |  |                                |   | |                      |     |                       |                         |                            |  |    |
    /// |                                            |  |                                +---+-+-*valRemapAmount  *out+-----+-o*someInput_B         |                         |                            |  |    |
    /// |                                            |  |                                    | |                      |     |                       |                         |                            |  |    |
    /// |                                            |  |                                    | +----------------------+     +-----------------------+                         |                            |  |    |
    /// |                                            |  |                                    |                                                                                |                            |  |    |
    /// |                                            |  |                                    |                                                                                |                            |  |    |
    /// |                                            |  |                                    |                                                                                |                            |  |    |
    /// |                                            |  |                                    |                                                                                |                            |  |    |
    /// |                                            |  |                                    +--------------------------------------------------------------------------------+                            |  |    |
    /// |                                            |  |                                                                                                                                                  |  |    |
    /// |                                            |  +--------------------------------------------------------------------------------------------------------------------------------------------------+  |    |
    /// |                                            |                                                                                                                                                        |    |
    /// |                                            +--------------------------------------------------------------------------------------------------------------------------------------------------------+    |
    /// |                                                                                                                                                                                                          |
    /// +----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
    
    /// @}

    HD_API
    HdMaterialNetworkSchema GetMaterialNetwork();

    HD_API
    HdMaterialNetworkSchema GetMaterialNetwork(TfToken const &context);

    HD_API
    HdMaterialNetworkSchema GetMaterialNetwork(TfTokenVector const &contexts);

    // Find the terminal (surface/volume/displcement) from a given data source locator.
    HD_API
    static TfToken
    GetLocatorTerminal(
        HdDataSourceLocator const& locator);

    HD_API
    static TfToken 
    GetLocatorTerminal(
        HdDataSourceLocator const& locator, 
        TfToken const& context);

    HD_API
    static TfToken 
    GetLocatorTerminal(
        HdDataSourceLocator const& locator, 
        TfTokenVector const &contexts);

// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{ 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        size_t count,
        const TfToken *names,
        const HdDataSourceBaseHandle *values);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif