//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "pxr/usd/usdContrived/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdContrivedTokensType::UsdContrivedTokensType() :
    asset("asset", TfToken::Immortal),
    assetArray("assetArray", TfToken::Immortal),
    attrWithoutGeneratedAccessorAPI("attrWithoutGeneratedAccessorAPI", TfToken::Immortal),
    binding("binding", TfToken::Immortal),
    bool_("bool", TfToken::Immortal),
    boolArray("boolArray", TfToken::Immortal),
    color3d("color3d", TfToken::Immortal),
    color3dArray("color3dArray", TfToken::Immortal),
    color3f("color3f", TfToken::Immortal),
    color3fArray("color3fArray", TfToken::Immortal),
    color3h("color3h", TfToken::Immortal),
    color3hArray("color3hArray", TfToken::Immortal),
    color4d("color4d", TfToken::Immortal),
    color4dArray("color4dArray", TfToken::Immortal),
    color4f("color4f", TfToken::Immortal),
    color4fArray("color4fArray", TfToken::Immortal),
    color4h("color4h", TfToken::Immortal),
    color4hArray("color4hArray", TfToken::Immortal),
    cornerIndices("cornerIndices", TfToken::Immortal),
    cornerSharpnesses("cornerSharpnesses", TfToken::Immortal),
    creaseLengths("creaseLengths", TfToken::Immortal),
    double2("double2", TfToken::Immortal),
    double2Array("double2Array", TfToken::Immortal),
    double3("double3", TfToken::Immortal),
    double3Array("double3Array", TfToken::Immortal),
    double4("double4", TfToken::Immortal),
    double4Array("double4Array", TfToken::Immortal),
    double_("double", TfToken::Immortal),
    doubleArray("doubleArray", TfToken::Immortal),
    float2("float2", TfToken::Immortal),
    float2Array("float2Array", TfToken::Immortal),
    float3("float3", TfToken::Immortal),
    float3Array("float3Array", TfToken::Immortal),
    float4("float4", TfToken::Immortal),
    float4Array("float4Array", TfToken::Immortal),
    float_("float", TfToken::Immortal),
    floatArray("floatArray", TfToken::Immortal),
    frame4d("frame4d", TfToken::Immortal),
    frame4dArray("frame4dArray", TfToken::Immortal),
    half("half", TfToken::Immortal),
    half2("half2", TfToken::Immortal),
    half2Array("half2Array", TfToken::Immortal),
    half3("half3", TfToken::Immortal),
    half3Array("half3Array", TfToken::Immortal),
    half4("half4", TfToken::Immortal),
    half4Array("half4Array", TfToken::Immortal),
    halfArray("halfArray", TfToken::Immortal),
    holeIndices("holeIndices", TfToken::Immortal),
    int2("int2", TfToken::Immortal),
    int2Array("int2Array", TfToken::Immortal),
    int3("int3", TfToken::Immortal),
    int3Array("int3Array", TfToken::Immortal),
    int4("int4", TfToken::Immortal),
    int4Array("int4Array", TfToken::Immortal),
    int64("int64", TfToken::Immortal),
    int64Array("int64Array", TfToken::Immortal),
    int_("int", TfToken::Immortal),
    intArray("intArray", TfToken::Immortal),
    justDefault("justDefault", TfToken::Immortal),
    libraryToken1("libraryToken1", TfToken::Immortal),
    libraryToken2("/non-identifier-tokenValue!", TfToken::Immortal),
    matrix2d("matrix2d", TfToken::Immortal),
    matrix2dArray("matrix2dArray", TfToken::Immortal),
    matrix3d("matrix3d", TfToken::Immortal),
    matrix3dArray("matrix3dArray", TfToken::Immortal),
    matrix4d("matrix4d", TfToken::Immortal),
    matrix4dArray("matrix4dArray", TfToken::Immortal),
    myDouble("myDouble", TfToken::Immortal),
    myUniformBool("myUniformBool", TfToken::Immortal),
    myVaryingToken("myVaryingToken", TfToken::Immortal),
    myVaryingTokenArray("myVaryingTokenArray", TfToken::Immortal),
    myVecfArray("myVecfArray", TfToken::Immortal),
    namespacedProperty("namespaced:property", TfToken::Immortal),
    newToken("newToken", TfToken::Immortal),
    normal3d("normal3d", TfToken::Immortal),
    normal3dArray("normal3dArray", TfToken::Immortal),
    normal3f("normal3f", TfToken::Immortal),
    normal3fArray("normal3fArray", TfToken::Immortal),
    normal3h("normal3h", TfToken::Immortal),
    normal3hArray("normal3hArray", TfToken::Immortal),
    overrideBaseFalseDerivedFalse("overrideBaseFalseDerivedFalse", TfToken::Immortal),
    overrideBaseFalseDerivedNone("overrideBaseFalseDerivedNone", TfToken::Immortal),
    overrideBaseNoneDerivedFalse("overrideBaseNoneDerivedFalse", TfToken::Immortal),
    overrideBaseTrueDerivedFalse("overrideBaseTrueDerivedFalse", TfToken::Immortal),
    overrideBaseTrueDerivedNone("overrideBaseTrueDerivedNone", TfToken::Immortal),
    overrideBaseTrueDerivedTrue("overrideBaseTrueDerivedTrue", TfToken::Immortal),
    pivotPosition("pivotPosition", TfToken::Immortal),
    point3d("point3d", TfToken::Immortal),
    point3dArray("point3dArray", TfToken::Immortal),
    point3f("point3f", TfToken::Immortal),
    point3fArray("point3fArray", TfToken::Immortal),
    point3h("point3h", TfToken::Immortal),
    point3hArray("point3hArray", TfToken::Immortal),
    quatd("quatd", TfToken::Immortal),
    quatdArray("quatdArray", TfToken::Immortal),
    quatf("quatf", TfToken::Immortal),
    quatfArray("quatfArray", TfToken::Immortal),
    quath("quath", TfToken::Immortal),
    quathArray("quathArray", TfToken::Immortal),
    relCanShareApiNameWithAttr("relCanShareApiNameWithAttr", TfToken::Immortal),
    riStatementsAttributesUserGofur_GeomOnHairdensity("riStatements:attributes:user:Gofur_GeomOnHairdensity", TfToken::Immortal),
    schemaToken1("schemaToken1", TfToken::Immortal),
    schemaToken2("/non-identifier-tokenValue!", TfToken::Immortal),
    string("string", TfToken::Immortal),
    stringArray("stringArray", TfToken::Immortal),
    temp("temp", TfToken::Immortal),
    test("test", TfToken::Immortal),
    test_MultipleApplyTemplate_("test:__INSTANCE_NAME__", TfToken::Immortal),
    test_MultipleApplyTemplate_TestAttrOne("test:__INSTANCE_NAME__:testAttrOne", TfToken::Immortal),
    test_MultipleApplyTemplate_TestAttrTwo("test:__INSTANCE_NAME__:testAttrTwo", TfToken::Immortal),
    testAttrDuplicate("testAttrDuplicate", TfToken::Immortal),
    testAttrExternal("testAttrExternal", TfToken::Immortal),
    testAttrInternal("testAttrInternal", TfToken::Immortal),
    testAttrOne("testAttrOne", TfToken::Immortal),
    testAttrTwo("testAttrTwo", TfToken::Immortal),
    testingAsset("testingAsset", TfToken::Immortal),
    testNewVersion("testNewVersion", TfToken::Immortal),
    testNewVersion_MultipleApplyTemplate_TestAttrOne("testNewVersion:__INSTANCE_NAME__:testAttrOne", TfToken::Immortal),
    testNewVersion_MultipleApplyTemplate_TestAttrTwo("testNewVersion:__INSTANCE_NAME__:testAttrTwo", TfToken::Immortal),
    testo("testo", TfToken::Immortal),
    testo_MultipleApplyTemplate_("testo:__INSTANCE_NAME__", TfToken::Immortal),
    testo_MultipleApplyTemplate_TestAttrOne("testo:__INSTANCE_NAME__:testAttrOne", TfToken::Immortal),
    testo_MultipleApplyTemplate_TestAttrTwo("testo:__INSTANCE_NAME__:testAttrTwo", TfToken::Immortal),
    testRelDuplicate("testRelDuplicate", TfToken::Immortal),
    testRelExternal("testRelExternal", TfToken::Immortal),
    testRelInternal("testRelInternal", TfToken::Immortal),
    token("token", TfToken::Immortal),
    tokenArray("tokenArray", TfToken::Immortal),
    transform("transform", TfToken::Immortal),
    uchar("uchar", TfToken::Immortal),
    ucharArray("ucharArray", TfToken::Immortal),
    uint("uint", TfToken::Immortal),
    uint64("uint64", TfToken::Immortal),
    uint64Array("uint64Array", TfToken::Immortal),
    uintArray("uintArray", TfToken::Immortal),
    VariableTokenAllowed1("VariableTokenAllowed1", TfToken::Immortal),
    VariableTokenAllowed2("VariableTokenAllowed2", TfToken::Immortal),
    VariableTokenAllowed_3_("VariableTokenAllowed<3>", TfToken::Immortal),
    VariableTokenArrayAllowed1("VariableTokenArrayAllowed1", TfToken::Immortal),
    VariableTokenArrayAllowed2("VariableTokenArrayAllowed2", TfToken::Immortal),
    VariableTokenArrayAllowed_3_("VariableTokenArrayAllowed<3>", TfToken::Immortal),
    VariableTokenDefault("VariableTokenDefault", TfToken::Immortal),
    vector3d("vector3d", TfToken::Immortal),
    vector3dArray("vector3dArray", TfToken::Immortal),
    vector3f("vector3f", TfToken::Immortal),
    vector3fArray("vector3fArray", TfToken::Immortal),
    vector3h("vector3h", TfToken::Immortal),
    vector3hArray("vector3hArray", TfToken::Immortal),
    Base("Base", TfToken::Immortal),
    Derived("Derived", TfToken::Immortal),
    DerivedNonAppliedAPI("DerivedNonAppliedAPI", TfToken::Immortal),
    EmptyMultipleApplyAPI("EmptyMultipleApplyAPI", TfToken::Immortal),
    MultipleApplyAPI("MultipleApplyAPI", TfToken::Immortal),
    MultipleApplyAPI_1("MultipleApplyAPI_1", TfToken::Immortal),
    NonAppliedAPI("NonAppliedAPI", TfToken::Immortal),
    PublicMultipleApplyAPI("PublicMultipleApplyAPI", TfToken::Immortal),
    SingleApplyAPI("SingleApplyAPI", TfToken::Immortal),
    SingleApplyAPI_1("SingleApplyAPI_1", TfToken::Immortal),
    TestNoVersion0("TestNoVersion0", TfToken::Immortal),
    TestNoVersion0_2("TestNoVersion0_2", TfToken::Immortal),
    TestPropertyOrderSingleApplyAPI("TestPropertyOrderSingleApplyAPI", TfToken::Immortal),
    TestPropertyOrderTyped("TestPropertyOrderTyped", TfToken::Immortal),
    TestPxHairman("TestPxHairman", TfToken::Immortal),
    TestPxHairman_1("TestPxHairman_1", TfToken::Immortal),
    TestReflectedAPIBase("TestReflectedAPIBase", TfToken::Immortal),
    TestReflectedExternalAPI("TestReflectedExternalAPI", TfToken::Immortal),
    TestReflectedInternalAPI("TestReflectedInternalAPI", TfToken::Immortal),
    UsdContrivedNoAlias("UsdContrivedNoAlias", TfToken::Immortal),
    allTokens({
        asset,
        assetArray,
        attrWithoutGeneratedAccessorAPI,
        binding,
        bool_,
        boolArray,
        color3d,
        color3dArray,
        color3f,
        color3fArray,
        color3h,
        color3hArray,
        color4d,
        color4dArray,
        color4f,
        color4fArray,
        color4h,
        color4hArray,
        cornerIndices,
        cornerSharpnesses,
        creaseLengths,
        double2,
        double2Array,
        double3,
        double3Array,
        double4,
        double4Array,
        double_,
        doubleArray,
        float2,
        float2Array,
        float3,
        float3Array,
        float4,
        float4Array,
        float_,
        floatArray,
        frame4d,
        frame4dArray,
        half,
        half2,
        half2Array,
        half3,
        half3Array,
        half4,
        half4Array,
        halfArray,
        holeIndices,
        int2,
        int2Array,
        int3,
        int3Array,
        int4,
        int4Array,
        int64,
        int64Array,
        int_,
        intArray,
        justDefault,
        libraryToken1,
        libraryToken2,
        matrix2d,
        matrix2dArray,
        matrix3d,
        matrix3dArray,
        matrix4d,
        matrix4dArray,
        myDouble,
        myUniformBool,
        myVaryingToken,
        myVaryingTokenArray,
        myVecfArray,
        namespacedProperty,
        newToken,
        normal3d,
        normal3dArray,
        normal3f,
        normal3fArray,
        normal3h,
        normal3hArray,
        overrideBaseFalseDerivedFalse,
        overrideBaseFalseDerivedNone,
        overrideBaseNoneDerivedFalse,
        overrideBaseTrueDerivedFalse,
        overrideBaseTrueDerivedNone,
        overrideBaseTrueDerivedTrue,
        pivotPosition,
        point3d,
        point3dArray,
        point3f,
        point3fArray,
        point3h,
        point3hArray,
        quatd,
        quatdArray,
        quatf,
        quatfArray,
        quath,
        quathArray,
        relCanShareApiNameWithAttr,
        riStatementsAttributesUserGofur_GeomOnHairdensity,
        schemaToken1,
        schemaToken2,
        string,
        stringArray,
        temp,
        test,
        test_MultipleApplyTemplate_,
        test_MultipleApplyTemplate_TestAttrOne,
        test_MultipleApplyTemplate_TestAttrTwo,
        testAttrDuplicate,
        testAttrExternal,
        testAttrInternal,
        testAttrOne,
        testAttrTwo,
        testingAsset,
        testNewVersion,
        testNewVersion_MultipleApplyTemplate_TestAttrOne,
        testNewVersion_MultipleApplyTemplate_TestAttrTwo,
        testo,
        testo_MultipleApplyTemplate_,
        testo_MultipleApplyTemplate_TestAttrOne,
        testo_MultipleApplyTemplate_TestAttrTwo,
        testRelDuplicate,
        testRelExternal,
        testRelInternal,
        token,
        tokenArray,
        transform,
        uchar,
        ucharArray,
        uint,
        uint64,
        uint64Array,
        uintArray,
        VariableTokenAllowed1,
        VariableTokenAllowed2,
        VariableTokenAllowed_3_,
        VariableTokenArrayAllowed1,
        VariableTokenArrayAllowed2,
        VariableTokenArrayAllowed_3_,
        VariableTokenDefault,
        vector3d,
        vector3dArray,
        vector3f,
        vector3fArray,
        vector3h,
        vector3hArray,
        Base,
        Derived,
        DerivedNonAppliedAPI,
        EmptyMultipleApplyAPI,
        MultipleApplyAPI,
        MultipleApplyAPI_1,
        NonAppliedAPI,
        PublicMultipleApplyAPI,
        SingleApplyAPI,
        SingleApplyAPI_1,
        TestNoVersion0,
        TestNoVersion0_2,
        TestPropertyOrderSingleApplyAPI,
        TestPropertyOrderTyped,
        TestPxHairman,
        TestPxHairman_1,
        TestReflectedAPIBase,
        TestReflectedExternalAPI,
        TestReflectedInternalAPI,
        UsdContrivedNoAlias
    })
{
}

TfStaticData<UsdContrivedTokensType> UsdContrivedTokens;

PXR_NAMESPACE_CLOSE_SCOPE
