//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdImaging/materialBindingsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/usdImaging/usdImaging/materialBindingSchema.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdImagingMaterialBindingsSchemaTokens,
    USD_IMAGING_MATERIAL_BINDINGS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

TfTokenVector
UsdImagingMaterialBindingsSchema::GetPurposes() const
{
    if (HdContainerDataSourceHandle h = GetContainer()) {
        return h->GetNames();
    }

    return {};
}

UsdImagingMaterialBindingVectorSchema
UsdImagingMaterialBindingsSchema::GetMaterialBindings() const
{
    return UsdImagingMaterialBindingVectorSchema(
        _GetTypedDataSource<HdVectorDataSource>(
            UsdImagingMaterialBindingsSchemaTokens->allPurpose));
}

UsdImagingMaterialBindingVectorSchema
UsdImagingMaterialBindingsSchema::GetMaterialBindings(
    const TfToken &purpose) const
{
    return UsdImagingMaterialBindingVectorSchema(
        _GetTypedDataSource<HdVectorDataSource>(purpose));
}

// --(END CUSTOM CODE: Schema Methods)--

/*static*/
UsdImagingMaterialBindingsSchema
UsdImagingMaterialBindingsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdImagingMaterialBindingsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdImagingMaterialBindingsSchemaTokens->usdMaterialBindings))
        : nullptr);
}

/*static*/
const TfToken &
UsdImagingMaterialBindingsSchema::GetSchemaToken()
{
    return UsdImagingMaterialBindingsSchemaTokens->usdMaterialBindings;
}

/*static*/
const HdDataSourceLocator &
UsdImagingMaterialBindingsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE