//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/{{SCHEMA_NAME | uncapitalizeFirst}}Prim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/{{SCHEMA_NAME | uncapitalizeFirst}}Schema.h"
{%- for t in FORWARD_DECLS %}
#include "hdPrman/{{t | uncapitalizeFirst}}Prim.h"
{%- endfor %}
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_{{SCHEMA_NAME}}Prim::HdPrman_{{SCHEMA_NAME}}Prim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    {{SCHEMA_CLASS_NAME}} schema =
        {{SCHEMA_CLASS_NAME}}::GetFromParent(primSource);

{% for name, type_name, opt_dict in MEMBERS %}
    {{ opt_dict['RILEY_CONVERTER'] }} {{ name }} =
        {{ opt_dict['RILEY_CONVERTER'] }}(
{%- if 'RILEY_NEEDS_OBSERVER' in opt_dict %}
            observer,
{%- endif %}
            schema.Get{{name | capitalizeFirst}}()
{%- if 'FALLBACK_VALUE' in opt_dict %},
            /* fallbackValue = */ {{ opt_dict['FALLBACK_VALUE'] }}
{%- endif -%}
{%- if 'RILEY_NEEDS_SHUTTER_INTERVAL' in opt_dict %},
            _GetShutterInterval()
{%- endif -%}
    );
{% endfor %}

    _rileyId = _AcquireRiley()->Create{{RILEY_TYPE}}(
{%- if not NO_RILEY_USER_ID %}
        riley::UserId(),
{% endif -%}
{%- for name, type_name, opt_dict in MEMBERS %}
        {{name}}.rileyObject{% if not loop.last %},{% endif %}
{%- endfor -%}
        );
{% for name, type_name, opt_dict in MEMBERS -%}
{%- if 'RILEY_RELATIONSHIP_TARGET' in opt_dict %}
{%- if type_name == 'HdPathArrayDataSource' %}
    _{{name}}Prims = std::move({{name}}.prims);
{% else %}
    _{{name}}Prim = std::move({{name}}.prim);
{% endif -%}
{%- endif -%}
{%- endfor %}
// --(BEGIN CUSTOM CODE: Constructor)--
{%- if 'Constructor' in CUSTOM_CODE_IMPL %}
{{ CUSTOM_CODE_IMPL['Constructor'] }}
{%- endif %}
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_{{SCHEMA_NAME}}Prim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    {{SCHEMA_CLASS_NAME}} schema =
        {{SCHEMA_CLASS_NAME}}::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);

{% for name, type_name, opt_dict in MEMBERS -%}
{%- if not 'RILEY_NO_MODIFY' in opt_dict %}
    std::optional<{{ opt_dict['RILEY_CONVERTER'] }}> {{ name }};
    if (entry.dirtyLocators.Intersects(
            {{SCHEMA_CLASS_NAME}}::Get{{name | capitalizeFirst}}Locator())) {
        {{ name }} =
            {{ opt_dict['RILEY_CONVERTER'] }}(
{%- if 'RILEY_NEEDS_OBSERVER' in opt_dict %}
                observer,
{%- endif %}
                schema.Get{{name | capitalizeFirst}}()
{%- if 'FALLBACK_VALUE' in opt_dict %},
                {{ opt_dict['FALLBACK_VALUE'] }}
{%- endif -%}
{%- if 'RILEY_NEEDS_SHUTTER_INTERVAL' in opt_dict %},
                _GetShutterInterval()
{%- endif -%}
        );
    };
{% endif -%}
{%- endfor %}

    _AcquireRiley()->Modify{{RILEY_TYPE}}(
{%- if not 'Modify' in CUSTOM_CODE_IMPL -%}
        _rileyId,
{%- for name, type_name, opt_dict in MEMBERS -%}
{%- if not 'RILEY_NO_MODIFY' in opt_dict %}
        HdPrman_GetRileyObjectPtr({{name}}){% if not loop.last %},{% endif %}
{%- endif -%}
{%- endfor -%}
{%- endif %}
// --(BEGIN CUSTOM CODE: Modify)--
{%- if 'Modify' in CUSTOM_CODE_IMPL %}
{{ CUSTOM_CODE_IMPL['Modify'] }}
{%- endif %}
// --(END CUSTOM CODE: Modify)--
        );

{% for name, type_name, opt_dict in MEMBERS -%}
{%- if 'RILEY_RELATIONSHIP_TARGET' in opt_dict and not 'RILEY_NO_MODIFY' in opt_dict %}
{%- if type_name == 'HdPathArrayDataSource' %}
    // Now that the {{RILEY_TYPE}} is using the new
    // {{opt_dict['RILEY_RELATIONSHIP_TARGET']}}, we can realease the handles
    // to the old {{opt_dict['RILEY_RELATIONSHIP_TARGET']}}.
    if ({{name}}) {
        _{{name}}Prims = std::move({{name}}->prims);
    }
{% else %}
    if ({{name}}) {
        _{{name}}Prim = std::move({{name}}->prim);
    }
{% endif -%}
{%- endif -%}
{%- endfor %}
}

HdPrman_{{SCHEMA_NAME}}Prim::~HdPrman_{{SCHEMA_NAME}}Prim()
{
    _AcquireRiley()->Delete{{RILEY_TYPE}}(
{%- if not 'Delete' in CUSTOM_CODE_IMPL -%}
_rileyId
{%- endif %}
// --(BEGIN CUSTOM CODE: Delete)--
{%- if 'Delete' in CUSTOM_CODE_IMPL %}
{{ CUSTOM_CODE_IMPL['Delete'] }}
{%- endif %}
// --(END CUSTOM CODE: Delete)--
        );

{% for name, type_name, opt_dict in MEMBERS -%}
{%- if 'RILEY_RELATIONSHIP_TARGET' in opt_dict %}
{%- if type_name == 'HdPathArrayDataSource' %}
    // _{{name}}Prims gets dropped after the {{RILEY_TYPE}} was
    // deleted.
{% else %}
    // _{{name}}Prim gets dropped after the {{RILEY_TYPE}} was
    // deleted.
{% endif -%}
{%- endif -%}
{%- endfor -%}
}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER
