//
// Copyright 2019 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "hdPrman/points.h"

#include "hdPrman/renderParam.h"
#include "hdPrman/material.h"
#include "hdPrman/rixStrings.h"

#include "RiTypesHelper.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_Points::HdPrman_Points(SdfPath const& id)
    : BASE(id)
{
}

HdDirtyBits
HdPrman_Points::GetInitialDirtyBitsMask() const
{
    // The initial dirty bits control what data is available on the first
    // run through _PopulateRtPoints(), so it should list every data item
    // that _PopluateRtPoints requests.
    int mask = HdChangeTracker::Clean
        | HdChangeTracker::DirtyPoints
        | HdChangeTracker::DirtyTransform
        | HdChangeTracker::DirtyVisibility
        | HdChangeTracker::DirtyPrimvar
        | HdChangeTracker::DirtyNormals
        | HdChangeTracker::DirtyWidths
        | HdChangeTracker::DirtyMaterialId
        | HdChangeTracker::DirtyInstancer
        ;

    return (HdDirtyBits)mask;
}

bool
HdPrman_Points::_ConvertGeometry(
    HdPrman_RenderParam *renderParam,
    HdSceneDelegate *sceneDelegate,
    const SdfPath &id,
    RtUString *primType,
    RtPrimVarList *primvars,
    std::vector<HdGeomSubset> *geomSubsets,
    std::vector<RtPrimVarList> *geomSubsetPrimvars)
{
    const size_t npoints =
        HdPrman_ConvertPointsPrimvarForPoints(
            sceneDelegate, id, renderParam->GetShutterInterval(), *primvars);

    *primType = RixStr.k_Ri_Points;

    HdPrman_ConvertPrimvars(sceneDelegate, id, *primvars, 1,
                            npoints, npoints, npoints,
                            renderParam->GetShutterInterval());

    return true;
}

PXR_NAMESPACE_CLOSE_SCOPE
