//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyCameraSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyCameraSchemaTokens,
    HD_PRMAN_RILEY_CAMERA_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdPrmanRileyCameraSchema::GetName()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyCameraSchemaTokens->name);
}

HdPrmanRileyShadingNodeSchema
HdPrmanRileyCameraSchema::GetProjection()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyShadingNodeSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyCameraSchemaTokens->projection));
}

HdMatrixDataSourceHandle
HdPrmanRileyCameraSchema::GetXform()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdMatrixDataSource>(
        HdPrmanRileyCameraSchemaTokens->xform);
}

HdPrmanRileyParamListSchema
HdPrmanRileyCameraSchema::GetProperties()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyParamListSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyCameraSchemaTokens->properties));
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyCameraSchema::BuildRetained(
        const HdTokenDataSourceHandle &name,
        const HdContainerDataSourceHandle &projection,
        const HdMatrixDataSourceHandle &xform,
        const HdContainerDataSourceHandle &properties
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (name) {
        _names[_count] = HdPrmanRileyCameraSchemaTokens->name;
        _values[_count++] = name;
    }

    if (projection) {
        _names[_count] = HdPrmanRileyCameraSchemaTokens->projection;
        _values[_count++] = projection;
    }

    if (xform) {
        _names[_count] = HdPrmanRileyCameraSchemaTokens->xform;
        _values[_count++] = xform;
    }

    if (properties) {
        _names[_count] = HdPrmanRileyCameraSchemaTokens->properties;
        _values[_count++] = properties;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyCameraSchema::Builder &
HdPrmanRileyCameraSchema::Builder::SetName(
    const HdTokenDataSourceHandle &name)
{
    _name = name;
    return *this;
}

HdPrmanRileyCameraSchema::Builder &
HdPrmanRileyCameraSchema::Builder::SetProjection(
    const HdContainerDataSourceHandle &projection)
{
    _projection = projection;
    return *this;
}

HdPrmanRileyCameraSchema::Builder &
HdPrmanRileyCameraSchema::Builder::SetXform(
    const HdMatrixDataSourceHandle &xform)
{
    _xform = xform;
    return *this;
}

HdPrmanRileyCameraSchema::Builder &
HdPrmanRileyCameraSchema::Builder::SetProperties(
    const HdContainerDataSourceHandle &properties)
{
    _properties = properties;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyCameraSchema::Builder::Build()
{
    return HdPrmanRileyCameraSchema::BuildRetained(
        _name,
        _projection,
        _xform,
        _properties
    );
}

/*static*/
HdPrmanRileyCameraSchema
HdPrmanRileyCameraSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrmanRileyCameraSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrmanRileyCameraSchemaTokens->rileyCamera))
        : nullptr);
}

/*static*/
const TfToken &
HdPrmanRileyCameraSchema::GetSchemaToken()
{
    return HdPrmanRileyCameraSchemaTokens->rileyCamera;
}

/*static*/
const HdDataSourceLocator &
HdPrmanRileyCameraSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCameraSchema::GetNameLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCameraSchemaTokens->name);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCameraSchema::GetProjectionLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCameraSchemaTokens->projection);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCameraSchema::GetXformLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCameraSchemaTokens->xform);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCameraSchema::GetPropertiesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCameraSchemaTokens->properties);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE