//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyCoordinateSystemPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyCoordinateSystemSchema.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyCoordinateSystemPrim::HdPrman_RileyCoordinateSystemPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyCoordinateSystemSchema schema =
        HdPrmanRileyCoordinateSystemSchema::GetFromParent(primSource);


    HdPrman_RileyTransform xform =
        HdPrman_RileyTransform(
            schema.GetXform(),
            _GetShutterInterval());

    HdPrman_RileyParamList attributes =
        HdPrman_RileyParamList(
            schema.GetAttributes());


    _rileyId = _AcquireRiley()->CreateCoordinateSystem(
        riley::UserId(),

        xform.rileyObject,
        attributes.rileyObject);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyCoordinateSystemPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyCoordinateSystemSchema schema =
        HdPrmanRileyCoordinateSystemSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyTransform> xform;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyCoordinateSystemSchema::GetXformLocator())) {
        xform =
            HdPrman_RileyTransform(
                schema.GetXform(),
                _GetShutterInterval());
    };

    std::optional<HdPrman_RileyParamList> attributes;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyCoordinateSystemSchema::GetAttributesLocator())) {
        attributes =
            HdPrman_RileyParamList(
                schema.GetAttributes());
    };


    _AcquireRiley()->ModifyCoordinateSystem(_rileyId,
        HdPrman_GetRileyObjectPtr(xform),
        HdPrman_GetRileyObjectPtr(attributes)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


}

HdPrman_RileyCoordinateSystemPrim::~HdPrman_RileyCoordinateSystemPrim()
{
    _AcquireRiley()->DeleteCoordinateSystem(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );

}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER