//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyCoordinateSystemSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyCoordinateSystemSchemaTokens,
    HD_PRMAN_RILEY_COORDINATE_SYSTEM_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdMatrixDataSourceHandle
HdPrmanRileyCoordinateSystemSchema::GetXform()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdMatrixDataSource>(
        HdPrmanRileyCoordinateSystemSchemaTokens->xform);
}

HdPrmanRileyParamListSchema
HdPrmanRileyCoordinateSystemSchema::GetAttributes()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyParamListSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyCoordinateSystemSchemaTokens->attributes));
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyCoordinateSystemSchema::BuildRetained(
        const HdMatrixDataSourceHandle &xform,
        const HdContainerDataSourceHandle &attributes
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (xform) {
        _names[_count] = HdPrmanRileyCoordinateSystemSchemaTokens->xform;
        _values[_count++] = xform;
    }

    if (attributes) {
        _names[_count] = HdPrmanRileyCoordinateSystemSchemaTokens->attributes;
        _values[_count++] = attributes;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyCoordinateSystemSchema::Builder &
HdPrmanRileyCoordinateSystemSchema::Builder::SetXform(
    const HdMatrixDataSourceHandle &xform)
{
    _xform = xform;
    return *this;
}

HdPrmanRileyCoordinateSystemSchema::Builder &
HdPrmanRileyCoordinateSystemSchema::Builder::SetAttributes(
    const HdContainerDataSourceHandle &attributes)
{
    _attributes = attributes;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyCoordinateSystemSchema::Builder::Build()
{
    return HdPrmanRileyCoordinateSystemSchema::BuildRetained(
        _xform,
        _attributes
    );
}

/*static*/
HdPrmanRileyCoordinateSystemSchema
HdPrmanRileyCoordinateSystemSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrmanRileyCoordinateSystemSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrmanRileyCoordinateSystemSchemaTokens->rileyCoordinateSystem))
        : nullptr);
}

/*static*/
const TfToken &
HdPrmanRileyCoordinateSystemSchema::GetSchemaToken()
{
    return HdPrmanRileyCoordinateSystemSchemaTokens->rileyCoordinateSystem;
}

/*static*/
const HdDataSourceLocator &
HdPrmanRileyCoordinateSystemSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCoordinateSystemSchema::GetXformLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCoordinateSystemSchemaTokens->xform);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyCoordinateSystemSchema::GetAttributesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyCoordinateSystemSchemaTokens->attributes);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE