//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyDisplayFilterSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyDisplayFilterSchemaTokens,
    HD_PRMAN_RILEY_DISPLAY_FILTER_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPrmanRileyShadingNodeVectorSchema
HdPrmanRileyDisplayFilterSchema::GetDisplayFilter()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyShadingNodeVectorSchema(_GetTypedDataSource<HdVectorDataSource>(
        HdPrmanRileyDisplayFilterSchemaTokens->displayFilter));
}

HdPrmanRileyParamListSchema
HdPrmanRileyDisplayFilterSchema::GetAttributes()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyParamListSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyDisplayFilterSchemaTokens->attributes));
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyDisplayFilterSchema::BuildRetained(
        const HdVectorDataSourceHandle &displayFilter,
        const HdContainerDataSourceHandle &attributes
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (displayFilter) {
        _names[_count] = HdPrmanRileyDisplayFilterSchemaTokens->displayFilter;
        _values[_count++] = displayFilter;
    }

    if (attributes) {
        _names[_count] = HdPrmanRileyDisplayFilterSchemaTokens->attributes;
        _values[_count++] = attributes;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyDisplayFilterSchema::Builder &
HdPrmanRileyDisplayFilterSchema::Builder::SetDisplayFilter(
    const HdVectorDataSourceHandle &displayFilter)
{
    _displayFilter = displayFilter;
    return *this;
}

HdPrmanRileyDisplayFilterSchema::Builder &
HdPrmanRileyDisplayFilterSchema::Builder::SetAttributes(
    const HdContainerDataSourceHandle &attributes)
{
    _attributes = attributes;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyDisplayFilterSchema::Builder::Build()
{
    return HdPrmanRileyDisplayFilterSchema::BuildRetained(
        _displayFilter,
        _attributes
    );
}

/*static*/
HdPrmanRileyDisplayFilterSchema
HdPrmanRileyDisplayFilterSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrmanRileyDisplayFilterSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrmanRileyDisplayFilterSchemaTokens->rileyDisplayFilter))
        : nullptr);
}

/*static*/
const TfToken &
HdPrmanRileyDisplayFilterSchema::GetSchemaToken()
{
    return HdPrmanRileyDisplayFilterSchemaTokens->rileyDisplayFilter;
}

/*static*/
const HdDataSourceLocator &
HdPrmanRileyDisplayFilterSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyDisplayFilterSchema::GetDisplayFilterLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyDisplayFilterSchemaTokens->displayFilter);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyDisplayFilterSchema::GetAttributesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyDisplayFilterSchemaTokens->attributes);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE