//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyDisplayPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyDisplaySchema.h"
#include "hdPrman/rileyRenderOutputPrim.h"
#include "hdPrman/rileyRenderTargetPrim.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyDisplayPrim::HdPrman_RileyDisplayPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyDisplaySchema schema =
        HdPrmanRileyDisplaySchema::GetFromParent(primSource);


    HdPrman_RileyId<HdPrman_RileyRenderTargetPrim> renderTarget =
        HdPrman_RileyId<HdPrman_RileyRenderTargetPrim>(
            observer,
            schema.GetRenderTarget());

    HdPrman_RileyString name =
        HdPrman_RileyString(
            schema.GetName());

    HdPrman_RileyString driver =
        HdPrman_RileyString(
            schema.GetDriver());

    HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim> renderOutputs =
        HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>(
            observer,
            schema.GetRenderOutputs());

    HdPrman_RileyParamList driverParams =
        HdPrman_RileyParamList(
            schema.GetDriverParams());


    _rileyId = _AcquireRiley()->CreateDisplay(
        riley::UserId(),

        renderTarget.rileyObject,
        name.rileyObject,
        driver.rileyObject,
        renderOutputs.rileyObject,
        driverParams.rileyObject);

    _renderTargetPrim = std::move(renderTarget.prim);

    _renderOutputsPrims = std::move(renderOutputs.prims);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyDisplayPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyDisplaySchema schema =
        HdPrmanRileyDisplaySchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyId<HdPrman_RileyRenderTargetPrim>> renderTarget;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyDisplaySchema::GetRenderTargetLocator())) {
        renderTarget =
            HdPrman_RileyId<HdPrman_RileyRenderTargetPrim>(
                observer,
                schema.GetRenderTarget());
    };

    std::optional<HdPrman_RileyString> name;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyDisplaySchema::GetNameLocator())) {
        name =
            HdPrman_RileyString(
                schema.GetName());
    };

    std::optional<HdPrman_RileyString> driver;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyDisplaySchema::GetDriverLocator())) {
        driver =
            HdPrman_RileyString(
                schema.GetDriver());
    };

    std::optional<HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>> renderOutputs;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyDisplaySchema::GetRenderOutputsLocator())) {
        renderOutputs =
            HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>(
                observer,
                schema.GetRenderOutputs());
    };

    std::optional<HdPrman_RileyParamList> driverParams;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyDisplaySchema::GetDriverParamsLocator())) {
        driverParams =
            HdPrman_RileyParamList(
                schema.GetDriverParams());
    };


    _AcquireRiley()->ModifyDisplay(_rileyId,
        HdPrman_GetRileyObjectPtr(renderTarget),
        HdPrman_GetRileyObjectPtr(name),
        HdPrman_GetRileyObjectPtr(driver),
        HdPrman_GetRileyObjectPtr(renderOutputs),
        HdPrman_GetRileyObjectPtr(driverParams)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


    if (renderTarget) {
        _renderTargetPrim = std::move(renderTarget->prim);
    }

    // Now that the Display is using the new
    // RileyRenderOutput, we can realease the handles
    // to the old RileyRenderOutput.
    if (renderOutputs) {
        _renderOutputsPrims = std::move(renderOutputs->prims);
    }

}

HdPrman_RileyDisplayPrim::~HdPrman_RileyDisplayPrim()
{
    _AcquireRiley()->DeleteDisplay(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );


    // _renderTargetPrim gets dropped after the Display was
    // deleted.

    // _renderOutputsPrims gets dropped after the Display was
    // deleted.
}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER