//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyGeometryPrototypePrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyGeometryPrototypeSchema.h"
#include "hdPrman/rileyDisplacementPrim.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyGeometryPrototypePrim::HdPrman_RileyGeometryPrototypePrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyGeometryPrototypeSchema schema =
        HdPrmanRileyGeometryPrototypeSchema::GetFromParent(primSource);


    HdPrman_RileyString type =
        HdPrman_RileyString(
            schema.GetType());

    HdPrman_RileyId<HdPrman_RileyDisplacementPrim> displacement =
        HdPrman_RileyId<HdPrman_RileyDisplacementPrim>(
            observer,
            schema.GetDisplacement());

    HdPrman_RileyPrimvarList primvars =
        HdPrman_RileyPrimvarList(
            schema.GetPrimvars(),
            _GetShutterInterval());


    _rileyId = _AcquireRiley()->CreateGeometryPrototype(
        riley::UserId(),

        type.rileyObject,
        displacement.rileyObject,
        primvars.rileyObject);

    _displacementPrim = std::move(displacement.prim);

// --(BEGIN CUSTOM CODE: Constructor)--
    _type = type.rileyObject;
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyGeometryPrototypePrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyGeometryPrototypeSchema schema =
        HdPrmanRileyGeometryPrototypeSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyId<HdPrman_RileyDisplacementPrim>> displacement;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyGeometryPrototypeSchema::GetDisplacementLocator())) {
        displacement =
            HdPrman_RileyId<HdPrman_RileyDisplacementPrim>(
                observer,
                schema.GetDisplacement());
    };

    std::optional<HdPrman_RileyPrimvarList> primvars;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyGeometryPrototypeSchema::GetPrimvarsLocator())) {
        primvars =
            HdPrman_RileyPrimvarList(
                schema.GetPrimvars(),
                _GetShutterInterval());
    };


    _AcquireRiley()->ModifyGeometryPrototype(
// --(BEGIN CUSTOM CODE: Modify)--
        _type,
        _rileyId,
        HdPrman_GetRileyObjectPtr(displacement),
        HdPrman_GetRileyObjectPtr(primvars)
// --(END CUSTOM CODE: Modify)--
        );


    if (displacement) {
        _displacementPrim = std::move(displacement->prim);
    }

}

HdPrman_RileyGeometryPrototypePrim::~HdPrman_RileyGeometryPrototypePrim()
{
    _AcquireRiley()->DeleteGeometryPrototype(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );


    // _displacementPrim gets dropped after the GeometryPrototype was
    // deleted.
}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER
