//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_PRIM_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_PRIM_H

#include "pxr/pxr.h"
#include "hdPrman/api.h"
#include "hdPrman/sceneIndexObserverApi.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyPrimBase.h"

PXR_NAMESPACE_OPEN_SCOPE

using HdPrman_RileyDisplacementPrimHandle =
    std::shared_ptr<class HdPrman_RileyDisplacementPrim>;

using HdPrman_RileyGeometryPrototypePrimHandle =
    std::shared_ptr<class HdPrman_RileyGeometryPrototypePrim>;

/// \class HdPrman_RileyGeometryPrototypePrim
///
/// Wraps a riley GeometryPrototype object, initializing or updating it
/// using the HdPrmanRileyGeometryPrototypeSchema.
///
class HdPrman_RileyGeometryPrototypePrim : public HdPrman_RileyPrimBase
{
public:
    HdPrman_RileyGeometryPrototypePrim(
        HdContainerDataSourceHandle const &primSource,
        const HdsiPrimManagingSceneIndexObserver *observer,
        HdPrman_RenderParam * renderParam);

    ~HdPrman_RileyGeometryPrototypePrim() override;

    using RileyId = riley::GeometryPrototypeId;

    const RileyId &GetRileyId() const { return _rileyId; }

protected:
    void _Dirty(
        const HdSceneIndexObserver::DirtiedPrimEntry &entry,
        const HdsiPrimManagingSceneIndexObserver * observer) override;

private:
    // If there is a riley render target constructed from a riley render
    // output, the render target needs to be deleted before the render
    // output is deleted.
    // To ensure this, we keep handles to the prims wrapping the render
    // outputs here.
    HdPrman_RileyDisplacementPrimHandle _displacementPrim;

// --(BEGIN CUSTOM CODE: Fields)--
    RtUString _type;
// --(END CUSTOM CODE: Fields)--

    RileyId _rileyId;
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#endif
