//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_SCHEMA_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_SCHEMA_H

/// \file

#include "hdPrman/api.h"
#include "hdPrman/rileyPrimvarListSchema.h"

#include "pxr/imaging/hd/schema.h"
#include "pxr/imaging/hd/version.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_SCHEMA_TOKENS \
    (RileyGeometryPrototype) \
    (type) \
    (displacement) \
    (primvars) \

TF_DECLARE_PUBLIC_TOKENS(HdPrmanRileyGeometryPrototypeSchemaTokens, HDPRMAN_API,
    HD_PRMAN_RILEY_GEOMETRY_PROTOTYPE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdPrmanRileyGeometryPrototypeSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPrmanRileyGeometryPrototypeSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "RileyGeometryPrototype" from the parent container and constructs a
    /// HdPrmanRileyGeometryPrototypeSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HDPRMAN_API
    static HdPrmanRileyGeometryPrototypeSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HDPRMAN_API
    HdTokenDataSourceHandle GetType()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdPathDataSourceHandle GetDisplacement()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdPrmanRileyPrimvarListSchema GetPrimvars()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif
 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HDPRMAN_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HDPRMAN_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate type.
    HDPRMAN_API
    static const HdDataSourceLocator &GetTypeLocator();

    /// Prim-level relative data source locator to locate displacement.
    HDPRMAN_API
    static const HdDataSourceLocator &GetDisplacementLocator();

    /// Prim-level relative data source locator to locate primvars.
    HDPRMAN_API
    static const HdDataSourceLocator &GetPrimvarsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HDPRMAN_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &type,
        const HdPathDataSourceHandle &displacement,
        const HdContainerDataSourceHandle &primvars
    );

    /// \class HdPrmanRileyGeometryPrototypeSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HDPRMAN_API
        Builder &SetType(
            const HdTokenDataSourceHandle &type);
        HDPRMAN_API
        Builder &SetDisplacement(
            const HdPathDataSourceHandle &displacement);
        HDPRMAN_API
        Builder &SetPrimvars(
            const HdContainerDataSourceHandle &primvars);

        /// Returns a container data source containing the members set thus far.
        HDPRMAN_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _type;
        HdPathDataSourceHandle _displacement;
        HdContainerDataSourceHandle _primvars;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif