//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyIntegratorPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyIntegratorSchema.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyIntegratorPrim::HdPrman_RileyIntegratorPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyIntegratorSchema schema =
        HdPrmanRileyIntegratorSchema::GetFromParent(primSource);


    HdPrman_RileyShadingNode integratorNode =
        HdPrman_RileyShadingNode(
            schema.GetIntegratorNode());


    _rileyId = _AcquireRiley()->CreateIntegrator(
        riley::UserId(),

        integratorNode.rileyObject);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyIntegratorPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyIntegratorSchema schema =
        HdPrmanRileyIntegratorSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyShadingNode> integratorNode;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyIntegratorSchema::GetIntegratorNodeLocator())) {
        integratorNode =
            HdPrman_RileyShadingNode(
                schema.GetIntegratorNode());
    };


    _AcquireRiley()->ModifyIntegrator(_rileyId,
        HdPrman_GetRileyObjectPtr(integratorNode)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


}

HdPrman_RileyIntegratorPrim::~HdPrman_RileyIntegratorPrim()
{
    _AcquireRiley()->DeleteIntegrator(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );

}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER