//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyIntegratorSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyIntegratorSchemaTokens,
    HD_PRMAN_RILEY_INTEGRATOR_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPrmanRileyShadingNodeSchema
HdPrmanRileyIntegratorSchema::GetIntegratorNode()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyShadingNodeSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyIntegratorSchemaTokens->integratorNode));
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyIntegratorSchema::BuildRetained(
        const HdContainerDataSourceHandle &integratorNode
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (integratorNode) {
        _names[_count] = HdPrmanRileyIntegratorSchemaTokens->integratorNode;
        _values[_count++] = integratorNode;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyIntegratorSchema::Builder &
HdPrmanRileyIntegratorSchema::Builder::SetIntegratorNode(
    const HdContainerDataSourceHandle &integratorNode)
{
    _integratorNode = integratorNode;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyIntegratorSchema::Builder::Build()
{
    return HdPrmanRileyIntegratorSchema::BuildRetained(
        _integratorNode
    );
}

/*static*/
HdPrmanRileyIntegratorSchema
HdPrmanRileyIntegratorSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrmanRileyIntegratorSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrmanRileyIntegratorSchemaTokens->rileyIntegrator))
        : nullptr);
}

/*static*/
const TfToken &
HdPrmanRileyIntegratorSchema::GetSchemaToken()
{
    return HdPrmanRileyIntegratorSchemaTokens->rileyIntegrator;
}

/*static*/
const HdDataSourceLocator &
HdPrmanRileyIntegratorSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyIntegratorSchema::GetIntegratorNodeLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyIntegratorSchemaTokens->integratorNode);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE