//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyLightShaderPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyLightShaderSchema.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyLightShaderPrim::HdPrman_RileyLightShaderPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyLightShaderSchema schema =
        HdPrmanRileyLightShaderSchema::GetFromParent(primSource);


    HdPrman_RileyShadingNetwork light =
        HdPrman_RileyShadingNetwork(
            schema.GetLight());

    HdPrman_RileyShadingNetwork lightFilter =
        HdPrman_RileyShadingNetwork(
            schema.GetLightFilter());


    _rileyId = _AcquireRiley()->CreateLightShader(
        riley::UserId(),

        light.rileyObject,
        lightFilter.rileyObject);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyLightShaderPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyLightShaderSchema schema =
        HdPrmanRileyLightShaderSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyShadingNetwork> light;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyLightShaderSchema::GetLightLocator())) {
        light =
            HdPrman_RileyShadingNetwork(
                schema.GetLight());
    };

    std::optional<HdPrman_RileyShadingNetwork> lightFilter;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyLightShaderSchema::GetLightFilterLocator())) {
        lightFilter =
            HdPrman_RileyShadingNetwork(
                schema.GetLightFilter());
    };


    _AcquireRiley()->ModifyLightShader(_rileyId,
        HdPrman_GetRileyObjectPtr(light),
        HdPrman_GetRileyObjectPtr(lightFilter)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


}

HdPrman_RileyLightShaderPrim::~HdPrman_RileyLightShaderPrim()
{
    _AcquireRiley()->DeleteLightShader(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );

}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER