//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyParamSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyParamSchemaTokens,
    HD_PRMAN_RILEY_PARAM_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdSampledDataSourceHandle
HdPrmanRileyParamSchema::GetValue()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdSampledDataSource>(
        HdPrmanRileyParamSchemaTokens->value);
}

HdTokenDataSourceHandle
HdPrmanRileyParamSchema::GetRole()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyParamSchemaTokens->role);
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyParamSchema::BuildRetained(
        const HdSampledDataSourceHandle &value,
        const HdTokenDataSourceHandle &role
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (value) {
        _names[_count] = HdPrmanRileyParamSchemaTokens->value;
        _values[_count++] = value;
    }

    if (role) {
        _names[_count] = HdPrmanRileyParamSchemaTokens->role;
        _values[_count++] = role;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyParamSchema::Builder &
HdPrmanRileyParamSchema::Builder::SetValue(
    const HdSampledDataSourceHandle &value)
{
    _value = value;
    return *this;
}

HdPrmanRileyParamSchema::Builder &
HdPrmanRileyParamSchema::Builder::SetRole(
    const HdTokenDataSourceHandle &role)
{
    _role = role;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyParamSchema::Builder::Build()
{
    return HdPrmanRileyParamSchema::BuildRetained(
        _value,
        _role
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE