//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_PARAM_SCHEMA_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_PARAM_SCHEMA_H

/// \file

#include "hdPrman/api.h"

#include "pxr/imaging/hd/schema.h"
#include "pxr/imaging/hd/version.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PRMAN_RILEY_PARAM_SCHEMA_TOKENS \
    (value) \
    (role) \

TF_DECLARE_PUBLIC_TOKENS(HdPrmanRileyParamSchemaTokens, HDPRMAN_API,
    HD_PRMAN_RILEY_PARAM_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdPrmanRileyParamSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPrmanRileyParamSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HDPRMAN_API
    HdSampledDataSourceHandle GetValue()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    /// Disambiguates what call to RtParamList::SetFOO to use. Can take values
    /// from HdPrimvarRoleTokens and HdPrmanRileyAdditionalRoleTokens.
    HDPRMAN_API
    HdTokenDataSourceHandle GetRole()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif
 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HDPRMAN_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdSampledDataSourceHandle &value,
        const HdTokenDataSourceHandle &role
    );

    /// \class HdPrmanRileyParamSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HDPRMAN_API
        Builder &SetValue(
            const HdSampledDataSourceHandle &value);
        HDPRMAN_API
        Builder &SetRole(
            const HdTokenDataSourceHandle &role);

        /// Returns a container data source containing the members set thus far.
        HDPRMAN_API
        HdContainerDataSourceHandle Build();

    private:
        HdSampledDataSourceHandle _value;
        HdTokenDataSourceHandle _role;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif