//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_PRIMVAR_LIST_SCHEMA_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_PRIMVAR_LIST_SCHEMA_H

/// \file

#include "hdPrman/api.h"
#include "hdPrman/rileySchemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"
#include "pxr/imaging/hd/version.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PRMAN_RILEY_PRIMVAR_LIST_SCHEMA_TOKENS \
    (numUniform) \
    (numVertex) \
    (numVarying) \
    (numFaceVarying) \
    (params) \
    (P) \

TF_DECLARE_PUBLIC_TOKENS(HdPrmanRileyPrimvarListSchemaTokens, HDPRMAN_API,
    HD_PRMAN_RILEY_PRIMVAR_LIST_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// Schema to describe RtPrimvarList.
//
// To obtain an RtPrimvarList we pass numUniform, numVertex, numVarying,
// numFaceVarying to the constructor, call RtPrimvarList::SetTimes if "P" (for
// points) is among the params and has samples and finally call the
// appropriate RtPrimvarList::SetFOO[Detail]( name, value[, detailType[,
// sampleTimeIndex]]).
//
// The HdPrmanRileyPrimvarSchema determines what SetFOO[Detail] method is
// valled with what value, detailType or sampleTimeIndex.
//
// For many data types or when detailType is constant, the behavior is the
// same as for the HdPrmanRileyParamSchema.
//
// Otherweise, we call SetFooDetail using HdPrmanRileyParamSchema similar as
// we did for HdPrmanRileyParamSchema but consuming the detailType data source
// as well. The value data source is only sampled at time 0.
//
// The "P" param is treated specially. It is the only param for which take
// time samples (from the sampled value data source) and always corresponds to
// a call to RtPrimvarList::SetPointDetail with detailType = vertex.
//

class HdPrmanRileyPrimvarListSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPrmanRileyPrimvarListSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HDPRMAN_API
    HdSizetDataSourceHandle GetNumUniform()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdSizetDataSourceHandle GetNumVertex()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdSizetDataSourceHandle GetNumVarying()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdSizetDataSourceHandle GetNumFaceVarying()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdPrmanRileyPrimvarContainerSchema GetParams()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif
 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HDPRMAN_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdSizetDataSourceHandle &numUniform,
        const HdSizetDataSourceHandle &numVertex,
        const HdSizetDataSourceHandle &numVarying,
        const HdSizetDataSourceHandle &numFaceVarying,
        const HdContainerDataSourceHandle &params
    );

    /// \class HdPrmanRileyPrimvarListSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HDPRMAN_API
        Builder &SetNumUniform(
            const HdSizetDataSourceHandle &numUniform);
        HDPRMAN_API
        Builder &SetNumVertex(
            const HdSizetDataSourceHandle &numVertex);
        HDPRMAN_API
        Builder &SetNumVarying(
            const HdSizetDataSourceHandle &numVarying);
        HDPRMAN_API
        Builder &SetNumFaceVarying(
            const HdSizetDataSourceHandle &numFaceVarying);
        HDPRMAN_API
        Builder &SetParams(
            const HdContainerDataSourceHandle &params);

        /// Returns a container data source containing the members set thus far.
        HDPRMAN_API
        HdContainerDataSourceHandle Build();

    private:
        HdSizetDataSourceHandle _numUniform;
        HdSizetDataSourceHandle _numVertex;
        HdSizetDataSourceHandle _numVarying;
        HdSizetDataSourceHandle _numFaceVarying;
        HdContainerDataSourceHandle _params;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif