//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyPrimvarSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyPrimvarSchemaTokens,
    HD_PRMAN_RILEY_PRIMVAR_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdSampledDataSourceHandle
HdPrmanRileyPrimvarSchema::GetValue()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdSampledDataSource>(
        HdPrmanRileyPrimvarSchemaTokens->value);
}

HdTokenDataSourceHandle
HdPrmanRileyPrimvarSchema::GetDetailType()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyPrimvarSchemaTokens->detailType);
}

HdTokenDataSourceHandle
HdPrmanRileyPrimvarSchema::GetRole()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyPrimvarSchemaTokens->role);
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyPrimvarSchema::BuildRetained(
        const HdSampledDataSourceHandle &value,
        const HdTokenDataSourceHandle &detailType,
        const HdTokenDataSourceHandle &role
)
{
    TfToken _names[3];
    HdDataSourceBaseHandle _values[3];

    size_t _count = 0;

    if (value) {
        _names[_count] = HdPrmanRileyPrimvarSchemaTokens->value;
        _values[_count++] = value;
    }

    if (detailType) {
        _names[_count] = HdPrmanRileyPrimvarSchemaTokens->detailType;
        _values[_count++] = detailType;
    }

    if (role) {
        _names[_count] = HdPrmanRileyPrimvarSchemaTokens->role;
        _values[_count++] = role;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyPrimvarSchema::Builder &
HdPrmanRileyPrimvarSchema::Builder::SetValue(
    const HdSampledDataSourceHandle &value)
{
    _value = value;
    return *this;
}

HdPrmanRileyPrimvarSchema::Builder &
HdPrmanRileyPrimvarSchema::Builder::SetDetailType(
    const HdTokenDataSourceHandle &detailType)
{
    _detailType = detailType;
    return *this;
}

HdPrmanRileyPrimvarSchema::Builder &
HdPrmanRileyPrimvarSchema::Builder::SetRole(
    const HdTokenDataSourceHandle &role)
{
    _role = role;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyPrimvarSchema::Builder::Build()
{
    return HdPrmanRileyPrimvarSchema::BuildRetained(
        _value,
        _detailType,
        _role
    );
}

/*static*/
HdTokenDataSourceHandle
HdPrmanRileyPrimvarSchema::BuildDetailTypeDataSource(
    const TfToken &detailType)
{

    if (detailType == HdPrmanRileyPrimvarSchemaTokens->constant) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    if (detailType == HdPrmanRileyPrimvarSchemaTokens->uniform) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    if (detailType == HdPrmanRileyPrimvarSchemaTokens->vertex) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    if (detailType == HdPrmanRileyPrimvarSchemaTokens->varying) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    if (detailType == HdPrmanRileyPrimvarSchemaTokens->facevarying) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    if (detailType == HdPrmanRileyPrimvarSchemaTokens->reference) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(detailType);
} 

PXR_NAMESPACE_CLOSE_SCOPE