//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyRenderOutputPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyRenderOutputSchema.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyRenderOutputPrim::HdPrman_RileyRenderOutputPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyRenderOutputSchema schema =
        HdPrmanRileyRenderOutputSchema::GetFromParent(primSource);


    HdPrman_RileyString name =
        HdPrman_RileyString(
            schema.GetName());

    HdPrman_RileyRenderOutputType type =
        HdPrman_RileyRenderOutputType(
            schema.GetType());

    HdPrman_RileyString source =
        HdPrman_RileyString(
            schema.GetSource());

    HdPrman_RileyString accumulationRule =
        HdPrman_RileyString(
            schema.GetAccumulationRule());

    HdPrman_RileyString filter =
        HdPrman_RileyString(
            schema.GetFilter());

    HdPrman_RileyFilterSize filterSize =
        HdPrman_RileyFilterSize(
            schema.GetFilterSize());

    HdPrman_RileyFloat relativePixelVariance =
        HdPrman_RileyFloat(
            schema.GetRelativePixelVariance(),
            /* fallbackValue = */ 1.0f);

    HdPrman_RileyParamList params =
        HdPrman_RileyParamList(
            schema.GetParams());


    _rileyId = _AcquireRiley()->CreateRenderOutput(
        riley::UserId(),

        name.rileyObject,
        type.rileyObject,
        source.rileyObject,
        accumulationRule.rileyObject,
        filter.rileyObject,
        filterSize.rileyObject,
        relativePixelVariance.rileyObject,
        params.rileyObject);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyRenderOutputPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyRenderOutputSchema schema =
        HdPrmanRileyRenderOutputSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyString> name;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetNameLocator())) {
        name =
            HdPrman_RileyString(
                schema.GetName());
    };

    std::optional<HdPrman_RileyRenderOutputType> type;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetTypeLocator())) {
        type =
            HdPrman_RileyRenderOutputType(
                schema.GetType());
    };

    std::optional<HdPrman_RileyString> source;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetSourceLocator())) {
        source =
            HdPrman_RileyString(
                schema.GetSource());
    };

    std::optional<HdPrman_RileyString> accumulationRule;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetAccumulationRuleLocator())) {
        accumulationRule =
            HdPrman_RileyString(
                schema.GetAccumulationRule());
    };

    std::optional<HdPrman_RileyString> filter;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetFilterLocator())) {
        filter =
            HdPrman_RileyString(
                schema.GetFilter());
    };

    std::optional<HdPrman_RileyFilterSize> filterSize;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetFilterSizeLocator())) {
        filterSize =
            HdPrman_RileyFilterSize(
                schema.GetFilterSize());
    };

    std::optional<HdPrman_RileyFloat> relativePixelVariance;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetRelativePixelVarianceLocator())) {
        relativePixelVariance =
            HdPrman_RileyFloat(
                schema.GetRelativePixelVariance(),
                1.0f);
    };

    std::optional<HdPrman_RileyParamList> params;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderOutputSchema::GetParamsLocator())) {
        params =
            HdPrman_RileyParamList(
                schema.GetParams());
    };


    _AcquireRiley()->ModifyRenderOutput(_rileyId,
        HdPrman_GetRileyObjectPtr(name),
        HdPrman_GetRileyObjectPtr(type),
        HdPrman_GetRileyObjectPtr(source),
        HdPrman_GetRileyObjectPtr(accumulationRule),
        HdPrman_GetRileyObjectPtr(filter),
        HdPrman_GetRileyObjectPtr(filterSize),
        HdPrman_GetRileyObjectPtr(relativePixelVariance),
        HdPrman_GetRileyObjectPtr(params)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


}

HdPrman_RileyRenderOutputPrim::~HdPrman_RileyRenderOutputPrim()
{
    _AcquireRiley()->DeleteRenderOutput(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );

}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER