//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyRenderOutputSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrmanRileyRenderOutputSchemaTokens,
    HD_PRMAN_RILEY_RENDER_OUTPUT_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetName()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->name);
}

HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetType()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->type);
}

HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetSource()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->source);
}

HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetAccumulationRule()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->accumulationRule);
}

HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetFilter()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->filter);
}

HdVec2fDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetFilterSize()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdVec2fDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->filterSize);
}

HdFloatDataSourceHandle
HdPrmanRileyRenderOutputSchema::GetRelativePixelVariance()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->relativePixelVariance);
}

HdPrmanRileyParamListSchema
HdPrmanRileyRenderOutputSchema::GetParams()
#if HD_API_VERSION >= 66
                                            const
#else
                                                 
#endif
{
    return HdPrmanRileyParamListSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdPrmanRileyRenderOutputSchemaTokens->params));
}

/*static*/
HdContainerDataSourceHandle
HdPrmanRileyRenderOutputSchema::BuildRetained(
        const HdTokenDataSourceHandle &name,
        const HdTokenDataSourceHandle &type,
        const HdTokenDataSourceHandle &source,
        const HdTokenDataSourceHandle &accumulationRule,
        const HdTokenDataSourceHandle &filter,
        const HdVec2fDataSourceHandle &filterSize,
        const HdFloatDataSourceHandle &relativePixelVariance,
        const HdContainerDataSourceHandle &params
)
{
    TfToken _names[8];
    HdDataSourceBaseHandle _values[8];

    size_t _count = 0;

    if (name) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->name;
        _values[_count++] = name;
    }

    if (type) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->type;
        _values[_count++] = type;
    }

    if (source) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->source;
        _values[_count++] = source;
    }

    if (accumulationRule) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->accumulationRule;
        _values[_count++] = accumulationRule;
    }

    if (filter) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->filter;
        _values[_count++] = filter;
    }

    if (filterSize) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->filterSize;
        _values[_count++] = filterSize;
    }

    if (relativePixelVariance) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->relativePixelVariance;
        _values[_count++] = relativePixelVariance;
    }

    if (params) {
        _names[_count] = HdPrmanRileyRenderOutputSchemaTokens->params;
        _values[_count++] = params;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetName(
    const HdTokenDataSourceHandle &name)
{
    _name = name;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetType(
    const HdTokenDataSourceHandle &type)
{
    _type = type;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetSource(
    const HdTokenDataSourceHandle &source)
{
    _source = source;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetAccumulationRule(
    const HdTokenDataSourceHandle &accumulationRule)
{
    _accumulationRule = accumulationRule;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetFilter(
    const HdTokenDataSourceHandle &filter)
{
    _filter = filter;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetFilterSize(
    const HdVec2fDataSourceHandle &filterSize)
{
    _filterSize = filterSize;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetRelativePixelVariance(
    const HdFloatDataSourceHandle &relativePixelVariance)
{
    _relativePixelVariance = relativePixelVariance;
    return *this;
}

HdPrmanRileyRenderOutputSchema::Builder &
HdPrmanRileyRenderOutputSchema::Builder::SetParams(
    const HdContainerDataSourceHandle &params)
{
    _params = params;
    return *this;
}

HdContainerDataSourceHandle
HdPrmanRileyRenderOutputSchema::Builder::Build()
{
    return HdPrmanRileyRenderOutputSchema::BuildRetained(
        _name,
        _type,
        _source,
        _accumulationRule,
        _filter,
        _filterSize,
        _relativePixelVariance,
        _params
    );
}

/*static*/
HdPrmanRileyRenderOutputSchema
HdPrmanRileyRenderOutputSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrmanRileyRenderOutputSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrmanRileyRenderOutputSchemaTokens->rileyRenderOutput))
        : nullptr);
}

/*static*/
const TfToken &
HdPrmanRileyRenderOutputSchema::GetSchemaToken()
{
    return HdPrmanRileyRenderOutputSchemaTokens->rileyRenderOutput;
}

/*static*/
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetNameLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->name);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetTypeLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->type);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetSourceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->source);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetAccumulationRuleLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->accumulationRule);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetFilterLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->filter);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetFilterSizeLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->filterSize);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetRelativePixelVarianceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->relativePixelVariance);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrmanRileyRenderOutputSchema::GetParamsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrmanRileyRenderOutputSchemaTokens->params);
    return locator;
}

/*static*/
HdTokenDataSourceHandle
HdPrmanRileyRenderOutputSchema::BuildTypeDataSource(
    const TfToken &type)
{

    if (type == HdPrmanRileyRenderOutputSchemaTokens->float_) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    if (type == HdPrmanRileyRenderOutputSchemaTokens->integer) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    if (type == HdPrmanRileyRenderOutputSchemaTokens->color) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    if (type == HdPrmanRileyRenderOutputSchemaTokens->vector) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(type);
} 

PXR_NAMESPACE_CLOSE_SCOPE