//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_RENDER_OUTPUT_SCHEMA_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_RENDER_OUTPUT_SCHEMA_H

/// \file

#include "hdPrman/api.h"
#include "hdPrman/rileyParamListSchema.h"

#include "pxr/imaging/hd/schema.h"
#include "pxr/imaging/hd/version.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PRMAN_RILEY_RENDER_OUTPUT_SCHEMA_TOKENS \
    (rileyRenderOutput) \
    (name) \
    (type) \
    (source) \
    (accumulationRule) \
    (filter) \
    (filterSize) \
    (relativePixelVariance) \
    (params) \
    ((float_, "float")) \
    (integer) \
    (color) \
    (vector) \

TF_DECLARE_PUBLIC_TOKENS(HdPrmanRileyRenderOutputSchemaTokens, HDPRMAN_API,
    HD_PRMAN_RILEY_RENDER_OUTPUT_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdPrmanRileyRenderOutputSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPrmanRileyRenderOutputSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "rileyRenderOutput" from the parent container and constructs a
    /// HdPrmanRileyRenderOutputSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HDPRMAN_API
    static HdPrmanRileyRenderOutputSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HDPRMAN_API
    HdTokenDataSourceHandle GetName()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdTokenDataSourceHandle GetType()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdTokenDataSourceHandle GetSource()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdTokenDataSourceHandle GetAccumulationRule()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdTokenDataSourceHandle GetFilter()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdVec2fDataSourceHandle GetFilterSize()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdFloatDataSourceHandle GetRelativePixelVariance()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif


    HDPRMAN_API
    HdPrmanRileyParamListSchema GetParams()
#if HD_API_VERSION >= 66
                                            const;
#else
                                                 ;
#endif
 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HDPRMAN_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HDPRMAN_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate name.
    HDPRMAN_API
    static const HdDataSourceLocator &GetNameLocator();

    /// Prim-level relative data source locator to locate type.
    HDPRMAN_API
    static const HdDataSourceLocator &GetTypeLocator();

    /// Prim-level relative data source locator to locate source.
    HDPRMAN_API
    static const HdDataSourceLocator &GetSourceLocator();

    /// Prim-level relative data source locator to locate accumulationRule.
    HDPRMAN_API
    static const HdDataSourceLocator &GetAccumulationRuleLocator();

    /// Prim-level relative data source locator to locate filter.
    HDPRMAN_API
    static const HdDataSourceLocator &GetFilterLocator();

    /// Prim-level relative data source locator to locate filterSize.
    HDPRMAN_API
    static const HdDataSourceLocator &GetFilterSizeLocator();

    /// Prim-level relative data source locator to locate relativePixelVariance.
    HDPRMAN_API
    static const HdDataSourceLocator &GetRelativePixelVarianceLocator();

    /// Prim-level relative data source locator to locate params.
    HDPRMAN_API
    static const HdDataSourceLocator &GetParamsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HDPRMAN_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &name,
        const HdTokenDataSourceHandle &type,
        const HdTokenDataSourceHandle &source,
        const HdTokenDataSourceHandle &accumulationRule,
        const HdTokenDataSourceHandle &filter,
        const HdVec2fDataSourceHandle &filterSize,
        const HdFloatDataSourceHandle &relativePixelVariance,
        const HdContainerDataSourceHandle &params
    );

    /// \class HdPrmanRileyRenderOutputSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HDPRMAN_API
        Builder &SetName(
            const HdTokenDataSourceHandle &name);
        HDPRMAN_API
        Builder &SetType(
            const HdTokenDataSourceHandle &type);
        HDPRMAN_API
        Builder &SetSource(
            const HdTokenDataSourceHandle &source);
        HDPRMAN_API
        Builder &SetAccumulationRule(
            const HdTokenDataSourceHandle &accumulationRule);
        HDPRMAN_API
        Builder &SetFilter(
            const HdTokenDataSourceHandle &filter);
        HDPRMAN_API
        Builder &SetFilterSize(
            const HdVec2fDataSourceHandle &filterSize);
        HDPRMAN_API
        Builder &SetRelativePixelVariance(
            const HdFloatDataSourceHandle &relativePixelVariance);
        HDPRMAN_API
        Builder &SetParams(
            const HdContainerDataSourceHandle &params);

        /// Returns a container data source containing the members set thus far.
        HDPRMAN_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _name;
        HdTokenDataSourceHandle _type;
        HdTokenDataSourceHandle _source;
        HdTokenDataSourceHandle _accumulationRule;
        HdTokenDataSourceHandle _filter;
        HdVec2fDataSourceHandle _filterSize;
        HdFloatDataSourceHandle _relativePixelVariance;
        HdContainerDataSourceHandle _params;

    };

    /// Returns token data source for use as type value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - HdPrmanRileyRenderOutputSchemaTokens->float_
    /// - HdPrmanRileyRenderOutputSchemaTokens->integer
    /// - HdPrmanRileyRenderOutputSchemaTokens->color
    /// - HdPrmanRileyRenderOutputSchemaTokens->vector
    HDPRMAN_API
    static HdTokenDataSourceHandle BuildTypeDataSource(
        const TfToken &type);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif